// $Id: itemdb.c,v 1.8 2003/06/29 05:56:44 lemit Exp $
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "db.h"
#include "grfio.h"
#include "map.h"
#include "itemdb.h"
#include "script.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

static struct dbt* item_db;

/*==========================================
 *
 *------------------------------------------
 */
struct item_data* itemdb_search(int nameid)
{
	struct item_data *id;

	id=numdb_search(item_db,nameid);
	if(id) return id;

	id=malloc(sizeof(struct item_data));
	if(id==NULL){
		printf("out of memory : itemdb_search\n");
		exit(1);
	}
	memset(id,0,sizeof(struct item_data));
	numdb_insert(item_db,nameid,id);

	id->nameid=nameid;
	id->value=10;
	id->weight=10;

	if(nameid>500 && nameid<600)
		id->type=0;   //heal item
	else if(nameid>600 && nameid<700)
		id->type=2;   //use item
	else if((nameid>700 && nameid<1100) ||
			(nameid>7000 && nameid<8000))
		id->type=3;   //correction
	else if(nameid>=1750 && nameid<1760)
		id->type=10;  //arrow
	else if(nameid>1100 && nameid<2000)
		id->type=4;   //weapon
	else if((nameid>2100 && nameid<3000) ||
			(nameid>5000 && nameid<6000))
		id->type=5;   //armor
	else if(nameid>4000 && nameid<5000)
		id->type=6;   //card

	return id;
}

/*==========================================
 *
 *------------------------------------------
 */
int itemdb_sellvalue(int nameid)
{
	return itemdb_search(nameid)->value/2;
}

/*==========================================
 *
 *------------------------------------------
 */
int itemdb_isequip(int nameid)
{
	int type=itemdb_type(nameid);
	if(type==0 || type==2 || type==3 || type==6 || type==10)
		return 0;
	return 1;
}

/*==========================================
 *
 *------------------------------------------
 */
int itemdb_equippoint(struct map_session_data* sd,int nameid)
{
	struct item_data *id=itemdb_search(nameid);

	return id->equip;
}

//
// 
//
/*==========================================
 *
 *------------------------------------------
 */
static int itemdb_read_itemslottable(void)
{
	char *buf,*p;
	int s;

	buf=grfio_read("data\\itemslottable.txt");
	if(buf==NULL)
		return -1;
	s=grfio_size("data\\itemslottable.txt");
	buf[s]=0;
	for(p=buf;p-buf<s;){
		int nameid,equip;
		sscanf(p,"%d#%d#",&nameid,&equip);
		itemdb_search(nameid)->equip=equip;
		p=strchr(p,10);
		if(!p) break;
		p++;
		p=strchr(p,10);
		if(!p) break;
		p++;
	}
	free(buf);

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
static int itemdb_readdb(void)
{
	FILE *fp;
	char line[1024];

	fp=fopen("db/item_db.txt","r");
	if(fp==NULL){
		printf("can't read db/item_db.txt\n");
		return -1;
	}
	while(fgets(line,1020,fp)){
		int nameid,i;
		char *str[55],*p,*np;
		struct item_data *id;

		for(i=0,p=line;i<17;i++){
			if((np=strchr(p,','))!=NULL){
				str[i]=p;
				*np=0;
				p=np+1;
			} else {
				str[i]=p;
				p+=strlen(p);
			}
		}

		nameid=atoi(str[0]);
		if(nameid<=0 || nameid>=20000)
			continue;

		//ID,Name,Jname,Type,Price,Sell,Weight,ATK,DEF,Range,Slot,Job,Gender,Loc,wLV,eLV,View
		id=itemdb_search(nameid);
		memcpy(id->name,str[1],24);
		memcpy(id->jname,str[2],24);
		id->type=atoi(str[3]);
		if(atoi(str[5]))
			id->value=-1;
		else
			id->value=atoi(str[4]);
		id->weight=atoi(str[6]);
		id->atk=atoi(str[7]);
		id->def=atoi(str[8]);
		id->range=atoi(str[9]);
		id->slot=atoi(str[10]);
		id->class=atoi(str[11]);
		id->sex=atoi(str[12]);
		if(id->equip != atoi(str[13])){
			//printf("%d : equip point %d -> %d\n",nameid,id->equip,atoi(str[13]));
			id->equip=atoi(str[13]);
		}
		id->wlv=atoi(str[14]);
		id->elv=atoi(str[15]);
		id->look=atoi(str[16]);

		if((np=strchr(p,'{'))==NULL){
			id->use_script=NULL;
			id->equip_script=NULL;
			continue;
		}
		id->use_script = parse_script(np,0);
		np=strchr(np+1,'{');
		if(np){
			id->equip_script = parse_script(np,0);
		} else {
			id->equip_script = NULL;
		}
	}
	fclose(fp);
	printf("read db/item_db.txt done\n");
	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
static int itemdb_final(void *key,void *data,va_list ap)
{
	struct item_data *id;

	id=data;
	if(id->use_script)
		free(id->use_script);
	if(id->equip_script)
		free(id->equip_script);
	free(id);

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
void do_final_itemdb(void)
{
	if(item_db){
		numdb_final(item_db,itemdb_final);
		item_db=NULL;
	}
}

/*==========================================
 *
 *------------------------------------------
 */
int do_init_itemdb(void)
{
	item_db = numdb_init();

	itemdb_read_itemslottable();
	itemdb_readdb();

	return 0;
}
