// $Id: map.c,v 1.11 2003/06/29 05:56:44 lemit Exp $
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "core.h"
#include "timer.h"
#include "db.h"
#include "grfio.h"
#include "map.h"
#include "chrif.h"
#include "clif.h"
#include "npc.h"
#include "pc.h"
#include "mob.h"
#include "chat.h"
#include "itemdb.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

//  staticǥ˼
static struct dbt * id_db;
static struct dbt * map_db;
static struct dbt * nick_db;

static int users;
static struct block_list *object[50000];
static int first_free_object_id,last_object_id;

struct map_data map[MAX_MAP_PER_SERVER];
int map_num=0;

/*==========================================
 * mapפǤ³
 * (charƤ)
 *------------------------------------------
 */
void map_setusers(int n)
{
	users=n;
}

/*==========================================
 * mapפǤ³ (/wؤα)
 *------------------------------------------
 */
int map_getusers(void)
{
	return users;
}

//
// block
//
/*==========================================
 * map[]block_listҤäƤ
 * bl->prevbl_headΥɥ쥹Ƥ
 *------------------------------------------
 */
static struct block_list bl_head;

/*==========================================
 * map[]block_listɲ
 * mobϿ¿Τ̥ꥹ
 *
 * linkѤߤγǧ̵
 *------------------------------------------
 */
int map_addblock(struct block_list *bl)
{
	int m,x,y;

	m=bl->m;
	x=bl->x;
	y=bl->y;
	if(m<0 || m>=map_num ||
	   x<0 || x>=map[m].xs ||
	   y<0 || y>=map[m].ys)
		return 1;

	if(bl->type==BL_MOB){
		bl->next = map[m].block_mob[x/BLOCK_SIZE+(y/BLOCK_SIZE)*map[m].bxs];
		bl->prev = &bl_head;
		if(bl->next) bl->next->prev = bl;
		map[m].block_mob[x/BLOCK_SIZE+(y/BLOCK_SIZE)*map[m].bxs] = bl;
	} else {
		bl->next = map[m].block[x/BLOCK_SIZE+(y/BLOCK_SIZE)*map[m].bxs];
		bl->prev = &bl_head;
		if(bl->next) bl->next->prev = bl;
		map[m].block[x/BLOCK_SIZE+(y/BLOCK_SIZE)*map[m].bxs] = bl;
		if(bl->type==BL_PC)
			map[m].users++;
	}

	return 0;
}

/*==========================================
 * map[]block_list鳰
 * prevNULLξlist˷ҤäƤʤ
 *------------------------------------------
 */
int map_delblock(struct block_list *bl)
{
	// blocklistȴƤ
	if(bl->prev==NULL){
		if(bl->next!=NULL){
			// prevNULLnextNULLǤʤΤͭäƤϤʤʤ
			printf("map_delblock error : bl->next!=NULL\n");
		}
		return 0;
	}

	if(bl->type==BL_PC)
		map[bl->m].users--;
	if(bl->next) bl->next->prev = bl->prev;
	if(bl->prev==&bl_head){
		// ꥹȤƬʤΤǡmap[]block_list򹹿
		if(bl->type==BL_MOB){
			map[bl->m].block_mob[bl->x/BLOCK_SIZE+(bl->y/BLOCK_SIZE)*map[bl->m].bxs] = bl->next;
		} else {
			map[bl->m].block[bl->x/BLOCK_SIZE+(bl->y/BLOCK_SIZE)*map[bl->m].bxs] = bl->next;
		}
	} else {
		bl->prev->next = bl->next;
	}
	bl->next = NULL;
	bl->prev = NULL;

	return 0;
}

/*==========================================
 * ϤPCͿ (̤)
 *------------------------------------------
 */
int map_countnearpc(int m,int x,int y)
{
	int bx,by,c=0;
	struct block_list *bl;

	if(map[m].users==0)
		return 0;
	for(by=y/BLOCK_SIZE-AREA_SIZE/BLOCK_SIZE-1;by<=y/BLOCK_SIZE+AREA_SIZE/BLOCK_SIZE+1;by++){
		if(by<0 || by>=map[m].bys)
			continue;
		for(bx=x/BLOCK_SIZE-AREA_SIZE/BLOCK_SIZE-1;bx<=x/BLOCK_SIZE+AREA_SIZE/BLOCK_SIZE+1;bx++){
			if(bx<0 || bx>=map[m].bxs)
				continue;
			bl = map[m].block[bx+by*map[m].bxs];
			for(;bl;bl=bl->next){
				if(bl->type==BL_PC)
					c++;
			}
		}
	}
	return c;
}

/*==========================================
 * map m (x0,y0)-(x1,y1)objФ
 * funcƤ
 * type!=0 ʤ餽μΤ
 *------------------------------------------
 */
void map_foreachinarea(int (*func)(struct block_list*,va_list),int m,int x0,int y0,int x1,int y1,int type,...)
{
	int bx,by;
	struct block_list *bl;
	va_list ap;

	va_start(ap,type);
	if(x0<0) x0=0;
	if(y0<0) y0=0;
	if(x1>=map[m].xs) x1=map[m].xs-1;
	if(y1>=map[m].ys) y1=map[m].ys-1;
	if(type==0 || type!=BL_MOB)
		for(by=y0/BLOCK_SIZE;by<=y1/BLOCK_SIZE;by++){
			for(bx=x0/BLOCK_SIZE;bx<=x1/BLOCK_SIZE;bx++){
				bl = map[m].block[bx+by*map[m].bxs];
				for(;bl;bl=bl->next){
					if(type && bl->type!=type)
						continue;
					if(bl->x>=x0 && bl->x<=x1 && bl->y>=y0 && bl->y<=y1)
						func(bl,ap);
				}
			}
		}
	if(type==0 || type==BL_MOB)
		for(by=y0/BLOCK_SIZE;by<=y1/BLOCK_SIZE;by++){
			for(bx=x0/BLOCK_SIZE;bx<=x1/BLOCK_SIZE;bx++){
				bl = map[m].block_mob[bx+by*map[m].bxs];
				for(;bl;bl=bl->next){
					if(bl->x>=x0 && bl->x<=x1 && bl->y>=y0 && bl->y<=y1)
						func(bl,ap);
				}
			}
		}
	va_end(ap);
}

/*==========================================
 * (x0,y0)-(x1,y1)(dx,dy)ư
 * ΰ賰ˤʤΰ(L)obj
 * ФfuncƤ
 *
 * dx,dy-1,0,1ΤߤȤ
 *------------------------------------------
 */
void map_foreachinmovearea(int (*func)(struct block_list*,va_list),int m,int x0,int y0,int x1,int y1,int dx,int dy,int type,...)
{
	int bx,by;
	struct block_list *bl;
	va_list ap;

	va_start(ap,type);
	if(dx==0 || dy==0){
		// ΰξ
		if(dx==0){
			if(dy<0){
				y0=y1+dy+1;
			} else {
				y1=y0+dy-1;
			}
		} else if(dy==0){
			if(dx<0){
				x0=x1+dx+1;
			} else {
				x1=x0+dx-1;
			}
		}
		if(x0<0) x0=0;
		if(y0<0) y0=0;
		if(x1>=map[m].xs) x1=map[m].xs-1;
		if(y1>=map[m].ys) y1=map[m].ys-1;
		for(by=y0/BLOCK_SIZE;by<=y1/BLOCK_SIZE;by++){
			for(bx=x0/BLOCK_SIZE;bx<=x1/BLOCK_SIZE;bx++){
				bl = map[m].block[bx+by*map[m].bxs];
				for(;bl;bl=bl->next){
					if(type && bl->type!=type)
						continue;
					if(bl->x>=x0 && bl->x<=x1 && bl->y>=y0 && bl->y<=y1)
						func(bl,ap);
				}
				bl = map[m].block_mob[bx+by*map[m].bxs];
				for(;bl;bl=bl->next){
					if(type && bl->type!=type)
						continue;
					if(bl->x>=x0 && bl->x<=x1 && bl->y>=y0 && bl->y<=y1)
						func(bl,ap);
				}
			}
		}
		va_end(ap);
		return;
	}
	// Lΰξ
	if(x0<0) x0=0;
	if(y0<0) y0=0;
	if(x1>=map[m].xs) x1=map[m].xs-1;
	if(y1>=map[m].ys) y1=map[m].ys-1;
	for(by=y0/BLOCK_SIZE;by<=y1/BLOCK_SIZE;by++){
		for(bx=x0/BLOCK_SIZE;bx<=x1/BLOCK_SIZE;bx++){
			bl = map[m].block[bx+by*map[m].bxs];
			for(;bl;bl=bl->next){
				if(type && bl->type!=type)
					continue;
				if(!(bl->x>=x0 && bl->x<=x1 && bl->y>=y0 && bl->y<=y1))
					continue;
				if((dx>0 && bl->x<x0+dx) || (dx<0 && bl->x>x1+dx) ||
				   (dy>0 && bl->y<y0+dy) || (dy<0 && bl->y>y1+dy))
					func(bl,ap);
			}
			bl = map[m].block_mob[bx+by*map[m].bxs];
			for(;bl;bl=bl->next){
				if(type && bl->type!=type)
					continue;
				if(!(bl->x>=x0 && bl->x<=x1 && bl->y>=y0 && bl->y<=y1))
					continue;
				if((dx>0 && bl->x<x0+dx) || (dx<0 && bl->x>x1+dx) ||
				   (dy>0 && bl->y<y0+dy) || (dy<0 && bl->y>y1+dy))
					func(bl,ap);
			}
		}
	}
	va_end(ap);
}

/*==========================================
 * ƥ䥨եѤΰobj
 * object[]ؤ¸id_dbϿޤ
 *
 * bl->id⤳ꤷ̵?
 *------------------------------------------
 */
int map_addobject(struct block_list *bl)
{
	int i;
	if(first_free_object_id<2 || first_free_object_id>=50000)
		first_free_object_id=2;
	for(i=first_free_object_id;i<50000;i++)
		if(object[i]==NULL)
			break;
	if(i==50000){
		printf("no free object id\n");
		return 0;
	}
	first_free_object_id=i;
	if(last_object_id<i)
		last_object_id=i;
	object[i]=bl;
	numdb_insert(id_db,i,bl);
	return i;
}

/*==========================================
 * objectβ
 * block_listκid_dbκ
 * object datafreeobject[]ؤNULL
 *
 * addȤо̵Τˤʤ
 *------------------------------------------
 */
int map_delobject(int id)
{
	if(object[id]==NULL)
		return 0;

	map_delblock(object[id]);
	numdb_erase(id_db,id);
	free(object[id]);
	object[id]=NULL;

	if(first_free_object_id>id)
		first_free_object_id=id;

	while(last_object_id>2 && object[last_object_id]==NULL)
		last_object_id--;

	return 0;
}

/*==========================================
 * objfuncƤ
 *
 * ̤ѡƥκ˻ȤäƤ
 *------------------------------------------
 */
void map_foreachobject(int (*func)(struct block_list*,va_list),int type,...)
{
	int i;
	va_list ap;

	va_start(ap,type);
	for(i=2;i<=last_object_id;i++){
		if(object[i]){
			if(type && object[i]->type!=type)
				continue;
			func(object[i],ap);
		}
	}
	va_end(ap);
}

/*==========================================
 * ƥä
 *
 * data==0λtimerǾä
 * data!=0λϽǾäȤư
 *
 * Ԥϡmap_clearflooritem(id)
 * map.h#defineƤ
 *------------------------------------------
 */
int map_clearflooritem_timer(int tid,unsigned int tick,int id,int data)
{
	struct flooritem_data *fitem;

	fitem = (struct flooritem_data *)object[id];
	if(fitem==NULL || fitem->bl.type!=BL_ITEM || (!data && fitem->cleartimer != tid)){
		printf("map_clearflooritem_timer : error\n");
		return 1;
	}
	if(data)
		delete_timer(fitem->cleartimer,map_clearflooritem_timer);
	clif_clearflooritem(fitem,0);
	map_delobject(fitem->bl.id);

	return 0;
}

/*==========================================
 * (m,x,y)μrangeޥζ(=ǽ)cell
 * ⤫Ŭʥޥܤκɸx+(y<<16)֤
 *
 * range=1ǥƥɥåӤΤ
 *------------------------------------------
 */
int map_searchrandfreecell(int m,int x,int y,int range)
{
	int free_cell,i,j,c;

	for(free_cell=0,i=-range;i<=range;i++){
		if(i+y<0 || i+y>=map[m].ys)
			continue;
		for(j=-range;j<=range;j++){
			if(j+x<0 || j+x>=map[m].xs)
				continue;
			if((c=read_gat(m,j+x,i+y))==1 || c==5)
				continue;
			free_cell++;
		}
	}
	if(free_cell==0)
		return -1;
	free_cell=rand()%free_cell;
	for(i=-range;i<=range;i++){
		if(i+y<0 || i+y>=map[m].ys)
			continue;
		for(j=-range;j<=range;j++){
			if(j+x<0 || j+x>=map[m].xs)
				continue;
			if((c=read_gat(m,j+x,i+y))==1 || c==5)
				continue;
			if(free_cell==0){
				x+=j;
				y+=i;
				i=range+1;
				break;
			}
			free_cell--;
		}
	}

	return x+(y<<16);
}

/*==========================================
 * (m,x,y)濴3x3˾ƥ
 *
 * item_dataamountʳcopy
 *------------------------------------------
 */
int map_addflooritem(struct item *item_data,int amount,int m,int x,int y)
{
	int xy,r;
	struct flooritem_data *fitem;

	if((xy=map_searchrandfreecell(m,x,y,1))<0)
		return 0;
	r=rand();

	fitem = malloc(sizeof(*fitem));
	if(fitem==NULL){
		printf("out of memory : map_addflooritem\n");
		exit(1);
	}
	fitem->bl.type=BL_ITEM;
	fitem->bl.m=m;
	fitem->bl.x=xy&0xffff;
	fitem->bl.y=(xy>>16)&0xffff;

	fitem->bl.id = map_addobject(&fitem->bl);
	if(fitem->bl.id==0){
		free(fitem);
		return 0;
	}

	memcpy(&fitem->item_data,item_data,sizeof(*item_data));
	fitem->item_data.amount=amount;
	fitem->subx=(r&3)*3+3;
	fitem->suby=((r>>2)&3)*3+3;
	fitem->cleartimer=add_timer(gettick()+LIFETIME_FLOORITEM*1000,map_clearflooritem_timer,fitem->bl.id,0);

	map_addblock(&fitem->bl);
	clif_dropflooritem(fitem);

	return fitem->bl.id;
}

/*==========================================
 * id_dbblɲ
 *------------------------------------------
 */
void map_addiddb(struct block_list *bl)
{
	numdb_insert(id_db,bl->id,bl);
}

/*==========================================
 * id_dbbl
 *------------------------------------------
 */
void map_deliddb(struct block_list *bl)
{
	numdb_erase(id_db,bl->id);
}

/*==========================================
 * nick_dbsdɲ
 *------------------------------------------
 */
void map_addnickdb(struct map_session_data *sd)
{
	strdb_insert(nick_db,sd->status.name,sd);
}

/*==========================================
 * PCquit map.cʬ
 *
 * quitμΤ㤦褦ʵ⤷Ƥ
 *------------------------------------------
 */
int map_quit(struct map_session_data *sd)
{
	if(sd->chatID)
		chat_leavechat(sd);

	clif_clearchar_area(&sd->bl,2);
	map_delblock(&sd->bl);
	numdb_erase(id_db,sd->bl.id);
	strdb_erase(nick_db,sd->status.name);

	return 0;
}

/*==========================================
 * idֹPCõʤNULL
 *------------------------------------------
 */
struct map_session_data * map_id2sd(int id)
{
	struct block_list *bl;

	bl=numdb_search(id_db,id);
	if(bl && bl->type==BL_PC)
		return (struct map_session_data*)bl;
	return NULL;
}

/*==========================================
 * ̾nickPCõʤNULL
 *------------------------------------------
 */
struct map_session_data * map_nick2sd(char *nick)
{
	return strdb_search(nick_db,nick);
}

/*==========================================
 * idֹʪõ
 * objectξΤ
 *------------------------------------------
 */
struct block_list * map_id2bl(int id)
{
	if(id<sizeof(object)/sizeof(object[0]))
		return object[id];
	return numdb_search(id_db,id);
}

/*==========================================
 * id_dbƤfunc¹
 *------------------------------------------
 */
int map_foreachiddb(int (*func)(void*,void*,va_list),...)
{
	va_list ap;

	va_start(ap,func);
	numdb_foreach(id_db,func,ap);
	va_end(ap);
	return 0;
}

/*==========================================
 * map.npcɲ (warpΰΤ)
 *------------------------------------------
 */
int map_addnpc(int m,struct npc_data *nd)
{
	int i;
	if(m<0 || m>=map_num)
		return -1;
	for(i=0;i<map[m].npc_num && i<MAX_NPC_PER_MAP;i++)
		if(map[m].npc[i]==NULL)
			break;
	if(i==MAX_NPC_PER_MAP){
		printf("too many NPCs in one map %s\n",map[m].name);
		return -1;
	}
	if(i==map[m].npc_num){
		map[m].npc_num++;
	}
	map[m].npc[i]=nd;
	nd->n = i;
	numdb_insert(id_db,nd->bl.id,nd);

	return i;
}

/*==========================================
 * map̾mapֹѴ
 *------------------------------------------
 */
int map_mapname2mapid(char *name)
{
	struct map_data *md;

	md=strdb_search(map_db,name);
	if(md==NULL || md->gat==NULL)
		return -1;
	return md->m;
}

/*==========================================
 * ¾map̾ip,portѴ
 *------------------------------------------
 */
int map_mapname2ipport(char *name,int *ip,int *port)
{
	struct map_data_other_server *mdos;

	mdos=strdb_search(map_db,name);
	if(mdos==NULL || mdos->gat)
		return -1;
	*ip=mdos->ip;
	*port=mdos->port;
	return 0;
}

// gat
/*==========================================
 * (m,x,y)ξ֤Ĵ٤
 *------------------------------------------
 */
int map_getcell(int m,int x,int y)
{
	if(x<0 || x>=map[m].xs-1 || y<0 || y>=map[m].ys-1)
		return 1;
	return map[m].gat[x+y*map[m].xs];
}

/*==========================================
 * (m,x,y)ξ֤tˤ
 *------------------------------------------
 */
int map_setcell(int m,int x,int y,int t)
{
	if(x<0 || x>=map[m].xs || y<0 || y>=map[m].ys)
		return t;
	return map[m].gat[x+y*map[m].xs]=t;
}

/*==========================================
 * ¾Υޥåפdbɲ
 *------------------------------------------
 */
int map_setipport(char *name,unsigned long ip,int port)
{
	struct map_data *md;
	struct map_data_other_server *mdos;

	md=strdb_search(map_db,name);
	if(md==NULL){ // not exist -> add new data
		mdos=malloc(sizeof(*mdos));
		if(mdos==NULL){
			printf("out of memory : map_setipport\n");
			exit(1);
		}
		memcpy(mdos->name,name,16);
		mdos->gat  = NULL;
		mdos->ip   = ip;
		mdos->port = port;
		strdb_insert(map_db,name,mdos);
	} else {
		if(md->gat){ // local -> check data
			if(ip!=clif_getip() || port!=clif_getport()){
				printf("from char server : %s -> %08lx:%d\n",name,ip,port);
				return 1;
			}
		} else { // update
			mdos=(struct map_data_other_server *)md;
			mdos->ip   = ip;
			mdos->port = port;
		}
	}
	return 0;
}

// 
/*==========================================
 * ޥå1ɤ߹
 *------------------------------------------
 */
static int map_readmap(int m,char *fn)
{
	unsigned char *gat;
	int s;
	int x,y,xs,ys;
	struct gat_1cell {float high[4]; int type;} *p;

	// read & convert fn
	gat=grfio_read(fn);
	if(gat==NULL)
		return -1;

	map[m].m=m;
	xs=map[m].xs=*(int*)(gat+6);
	ys=map[m].ys=*(int*)(gat+10);
	map[m].gat=malloc(s=map[m].xs*map[m].ys);
	if(map[m].gat==NULL){
		printf("out of memory : map_readmap gat\n");
		exit(1);
	}
	map[m].npc_num=0;
	map[m].users=0;
	for(y=0;y<ys;y++){
		p=(struct gat_1cell*)(gat+y*xs*20+14);
		for(x=0;x<xs;x++){
			if(p->type==0){
				// Ƚ
				map[m].gat[x+y*xs]=(p->high[0]>3 || p->high[1]>3 || p->high[2]>3 || p->high[3]>3) ? 3 : 0;
			} else {
				map[m].gat[x+y*xs]=p->type;
			}
			p++;
		}
	}
	free(gat);

	map[m].bxs=(xs+BLOCK_SIZE-1)/BLOCK_SIZE;
	map[m].bys=(ys+BLOCK_SIZE-1)/BLOCK_SIZE;

	map[m].block=malloc(map[m].bxs*map[m].bys*sizeof(struct block_list*));
	if(map[m].block==NULL){
		printf("out of memory : map_readmap block\n");
		exit(1);
	}
	memset(map[m].block,0,map[m].bxs*map[m].bys*sizeof(struct block_list*));

	map[m].block_mob=malloc(map[m].bxs*map[m].bys*sizeof(struct block_list*));
	if(map[m].block_mob==NULL){
		printf("out of memory : map_readmap block_mob\n");
		exit(1);
	}
	memset(map[m].block_mob,0,map[m].bxs*map[m].bys*sizeof(struct block_list*));

	strdb_insert(map_db,map[m].name,&map[m]);
	printf("%s read done\n",fn);

	return 0;
}

/*==========================================
 * Ƥmapǡɤ߹
 *------------------------------------------
 */
int map_readallmap(void)
{
	int i;
	char fn[256];

	// Υޥåפ¸ߤǧ
	for(i=0;i<map_num;i++){
		if(strstr(map[i].name,".gat")==NULL)
			continue;
		sprintf(fn,"data\\%s",map[i].name);
		grfio_size(fn);
	}
	for(i=0;i<map_num;i++){
		if(strstr(map[i].name,".gat")==NULL)
			continue;
		sprintf(fn,"data\\%s",map[i].name);
		map_readmap(i,fn);
	}
	return 0;
}

/*==========================================
 * ɤ߹mapɲä
 *------------------------------------------
 */
int map_addmap(char *mapname)
{
	if(map_num>=MAX_MAP_PER_SERVER-1){
		printf("too many map\n");
		return 1;
	}
	memcpy(map[map_num].name,mapname,16);
	map_num++;
	return 0;
}

/*==========================================
 * եɤ߹
 *------------------------------------------
 */
int map_config_read(char *cfgName)
{
	int i;
	char line[1024],w1[1024],w2[1024];
	FILE *fp;

	fp=fopen(cfgName,"r");
	if(fp==NULL){
		printf("file not found: %s\n",cfgName);
		return 1;
	}
	while(fgets(line,1020,fp)){
		i=sscanf(line,"%[^:]:%s",w1,w2);
		if(i!=2)
			continue;
		if(strcmp(w1,"userid")==0){
			chrif_setuserid(w2);
		} else if(strcmp(w1,"passwd")==0){
			chrif_setpasswd(w2);
		} else if(strcmp(w1,"char_ip")==0){
			chrif_setip(w2);
		} else if(strcmp(w1,"char_port")==0){
			chrif_setport(atoi(w2));
		} else if(strcmp(w1,"map_ip")==0){
			clif_setip(w2);
		} else if(strcmp(w1,"map_port")==0){
			clif_setport(atoi(w2));
		} else if(strcmp(w1,"map")==0){
			map_addmap(w2);
		} else if(strcmp(w1,"npc")==0){
			npc_addsrcfile(w2);
		}
	}
	fclose(fp);

	return 0;
}

/*==========================================
 * mapλ
 *------------------------------------------
 */
void do_final(void)
{
	do_final_itemdb();
}

/*==========================================
 * map縵
 *------------------------------------------
 */
int do_init(int argc,char *argv[])
{
	if(argv[1]){
		if(map_config_read(argv[1]))
			exit(1);
	}

	atexit(do_final);

	id_db = numdb_init();
	map_db = strdb_init(16);
	nick_db = strdb_init(24);

	grfio_init();
	map_readallmap();

	add_timer_func_list(map_clearflooritem_timer,"map_clearflooritem_timer");

	do_init_chrif();
	do_init_clif();
	do_init_mob();	// npcνmob_spawnơmob_db򻲾ȤΤinit_npc
	do_init_npc();
	do_init_pc();
	do_init_itemdb();

	return 0;
}
