// $Id: mob.c,v 1.14 2003/06/30 14:45:10 lemit Exp $
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "timer.h"
#include "db.h"
#include "map.h"
#include "clif.h"
#include "pc.h"
#include "mob.h"
#include "itemdb.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

#define MIN_MOBTHINKTIME 100

struct mob_db mob_db[2000];

/*==========================================
 * ץȥ (ɬפʪΤ)
 *------------------------------------------
 */
static int distance(int,int,int,int);
static int mob_makedummymobdb(int);
static int mob_timer(int,unsigned int,int,int);

/*==========================================
 * mobμ1ˤַ׻
 *------------------------------------------
 */
static int calc_next_walk_step(struct mob_data *md)
{
	if(md->walkpath.path_pos>=md->walkpath.path_len)
		return -1;
	if(md->walkpath.path[md->walkpath.path_pos]&1)
		return md->speed*14/10;
	return md->speed;
}

/*==========================================
 * mobԽ
 *------------------------------------------
 */
static int mob_walk(struct mob_data *md,unsigned int tick,int data)
{
	int moveblock;
	int i;
	static int dirx[8]={0,-1,-1,-1,0,1,1,1};
	static int diry[8]={1,1,0,-1,-1,-1,0,1};
	int x,y,dx,dy;

	md->state=MS_IDLE;
	if(md->walkpath.path_pos>=md->walkpath.path_len || md->walkpath.path_pos!=data)
		return 0;

	if(md->walkpath.path[md->walkpath.path_pos]>=8)
		return 1;

	x = md->bl.x;
	y = md->bl.y;
	dx = dirx[md->walkpath.path[md->walkpath.path_pos]];
	dy = diry[md->walkpath.path[md->walkpath.path_pos]];
	md->walkpath.path_pos++;
	moveblock = ( x/BLOCK_SIZE != (x+dx)/BLOCK_SIZE || y/BLOCK_SIZE != (y+dy)/BLOCK_SIZE);

	map_foreachinmovearea(clif_moboutsight,md->bl.m,x-AREA_SIZE,y-AREA_SIZE,x+AREA_SIZE,y+AREA_SIZE,dx,dy,BL_PC,md);

	x += dx;
	y += dy;

	if(moveblock) map_delblock(&md->bl);
	md->bl.x = x;
	md->bl.y = y;
	if(moveblock) map_addblock(&md->bl);

	map_foreachinmovearea(clif_mobinsight,md->bl.m,x-AREA_SIZE,y-AREA_SIZE,x+AREA_SIZE,y+AREA_SIZE,-dx,-dy,BL_PC,md);

	if((i=calc_next_walk_step(md))>0){
		md->timer=add_timer(tick+i,mob_timer,md->bl.id,md->walkpath.path_pos);
		md->state=MS_WALK;
	}
	return 0;
}

/*==========================================
 * mobι
 *------------------------------------------
 */
static int mob_attack(struct mob_data *md,unsigned int tick,int data)
{
	struct map_session_data *sd;
	int hitrate,hit,damage,type,atkmin,atkmax,i;

	md->state=MS_IDLE;
	sd=map_id2sd(md->target_id);
	if(sd==NULL || pc_isdead(sd) || md->bl.m != sd->bl.m ||
	   distance(md->bl.x,md->bl.y,sd->bl.x,sd->bl.y)>=13){
		md->target_id=0;
		return 0;
	}
	if(distance(md->bl.x,md->bl.y,sd->bl.x,sd->bl.y)>=2){
		md->state=MS_IDLE;
		return 0;
	}

	// ᡼׻ pc¦Τȸͭͽ
	hitrate=mob_db[md->class].dex+mob_db[md->class].lv-sd->flee+80;
	if(hitrate<5) hitrate=5;
	hit=rand()%100 < hitrate;

	type=0; // normal
	i=mob_db[md->class].str;
	damage = i/10 * i/10 + i;
	atkmin = mob_db[md->class].atk1;
	atkmax = mob_db[md->class].atk2;
	if(atkmin > atkmax) atkmin = atkmax;

	if(atkmax > atkmin)
		damage += atkmin + rand() % (atkmax-atkmin);
	else
		damage += atkmin ;

	damage = damage * (100 - sd->def) /100 - sd->paramc[2];
	if(damage<1) damage=1;

	//
	if(!hit){
		clif_damage(&md->bl,&sd->bl,tick,mob_db[md->class].amotion,sd->dmotion,0,1,0,0);
	} else {
		clif_damage(&md->bl,&sd->bl,tick,mob_db[md->class].amotion,sd->dmotion,damage,1/*div*/,type,0/*left*/);
		pc_damage(sd,damage);
	}

	md->timer=add_timer(tick+mob_db[md->class].adelay,mob_timer,md->bl.id,0);
	md->state=MS_ATTACK;

	return 0;
}


/*==========================================
 * mobtimer (timerؿ)
 * Ԥȹʬ
 *------------------------------------------
 */
static int mob_timer(int tid,unsigned int tick,int id,int data)
{
	struct mob_data *md;

	md=(struct mob_data*)map_id2bl(id);
	if(md==NULL || md->bl.type!=BL_MOB)
		return 1;

	if(md->timer != tid){
		printf("mob_timer %d != %d\n",md->timer,tid);
		return 0;
	}
	md->timer=-1;

	switch(md->state){
	case MS_WALK:
		mob_walk(md,tick,data);
		break;
	case MS_ATTACK:
		mob_attack(md,tick,data);
		break;
	default:
		printf("mob_timer : %d ?\n",md->state);
	}

	return 0;
}

/*==========================================
 * ưƤ륿ޤߤƾ֤ѹ
 *------------------------------------------
 */
int mob_changestate(struct mob_data *md,int state)
{
	int i;

	if(md->timer>0)
		delete_timer(md->timer,mob_timer);
	md->timer=-1;
	md->state=state;
	switch(state){
	case MS_WALK:
		if((i=calc_next_walk_step(md))>0){
			md->timer=add_timer(gettick()+i/2,mob_timer,md->bl.id,0);
		} else
			md->state=MS_IDLE;
		break;
	case MS_ATTACK:
		md->timer=add_timer(gettick()+100,mob_timer,md->bl.id,0);
		break;
	}

	return 0;
}

/*==========================================
 * mobư
 *------------------------------------------
 */
int mob_walktoxy(struct mob_data *md,int x,int y,int easy)
{
	struct walkpath_data wpd;

	if(path_search(&wpd,md->bl.m,md->bl.x,md->bl.y,x,y,easy))
		return 1;
	md->to_x=x;
	md->to_y=y;

	memcpy(&md->walkpath,&wpd,sizeof(wpd));

	mob_changestate(md,MS_WALK);
	clif_movemob(md);

	return 0;
}

/*==========================================
 * delayդmob spawn (timerؿ)
 *------------------------------------------
 */
static int mob_delayspawn(int tid,unsigned int tick,int m,int n)
{
	mob_spawn(m);
	return 0;
}

/*==========================================
 * spawnߥ󥰷׻
 *------------------------------------------
 */
int mob_setdelayspawn(int id)
{
	unsigned int spawntime,spawntime1,spawntime2,spawntime3;
	struct mob_data *md;

	md=(struct mob_data*)map_id2bl(id);
	if(md==NULL || md->bl.type!=BL_MOB)
		return -1;

	spawntime1=md->last_spawntime+md->spawndelay1;
	spawntime2=md->last_deadtime+md->spawndelay2;
	spawntime3=gettick()+5000;
	// spawntime = max(spawntime1,spawntime2,spawntime3);
	if(DIFF_TICK(spawntime1,spawntime2)>0){
		spawntime=spawntime1;
	} else {
		spawntime=spawntime2;
	}
	if(DIFF_TICK(spawntime3,spawntime)>0){
		spawntime=spawntime3;
	}

	add_timer(spawntime,mob_delayspawn,id,0);
	return 0;
}

/*==========================================
 * mobи⤳
 *------------------------------------------
 */
int mob_spawn(int id)
{
	int x=0,y=0,i=0,c;
	struct mob_data *md;

	md=(struct mob_data*)map_id2bl(id);
	if(md==NULL || md->bl.type!=BL_MOB)
		return -1;

	md->last_spawntime=gettick();
	map_delblock(&md->bl);

	do {
		int r=rand();
		if(md->x0==0 && md->y0==0){
			x=r%(map[md->bl.m].xs-2)+1;
			y=r/(map[md->bl.m].xs-2)%(map[md->bl.m].ys-2)+1;
		} else {
			x=md->x0+r%(md->xs+1)-md->xs/2;
			y=md->y0+r/(md->xs+1)%(md->ys+1)-md->ys/2;
		}
		i++;
	} while(((c=map_getcell(md->bl.m,x,y))==1 || c==5) && i<50);

	if(i==50){
		// printf("spawn error %d @ %s\n",id,map[md->bl.m].name);
		add_timer(gettick()+5000,mob_delayspawn,id,0);
		return 1;
	}

	md->to_x=md->bl.x=x;
	md->to_y=md->bl.y=y;
	md->dir=0;

	map_addblock(&md->bl);

	md->hp = mob_db[md->class].max_hp;
	if(md->hp<=0){
		mob_makedummymobdb(md->class);
		md->hp = mob_db[md->class].max_hp;
	}

	md->attacked_id = 0;
	md->target_id = 0;
	md->move_fail_count = 0;

	md->state = MS_IDLE;
	md->timer = -1;
	md->next_walktime = gettick()+rand()%50+5000;

	memset(md->dmglog,0,sizeof(md->dmglog));
	memset(md->lootitem,0,sizeof(md->lootitem));

	clif_spawnmob(md);

	return 0;
}

/*==========================================
 * 2ֵΥ׻
 *------------------------------------------
 */
static int distance(int x0,int y0,int x1,int y1)
{
	int dx,dy;

	dx=abs(x0-x1);
	dy=abs(y0-y1);
	return dx>dy ? dx : dy;
}

/*==========================================
 *
 *------------------------------------------
 */
static int mob_ai_sub_hard(struct block_list *bl,va_list ap)
{
	struct mob_data *md;
	struct map_session_data *sd;
	unsigned int tick;
	int i,dx,dy,ret,dist;

	md=(struct mob_data*)bl;
	tick=va_arg(ap,unsigned int);

	if(DIFF_TICK(tick,md->last_thinktime)<MIN_MOBTHINKTIME)
		return 0;
	md->last_thinktime=tick;

	// ޤ⤵줿ǧ
	if(md->attacked_id && md->target_id==0){
		sd=map_id2sd(md->attacked_id);
		if(sd==NULL || md->bl.m != sd->bl.m || distance(md->bl.x,md->bl.y,sd->bl.x,sd->bl.y)>=13){
			md->attacked_id=0;
		} else {
			md->target_id=md->attacked_id; // set target
			md->attacked_id=0;
		}
	}

	// оݤʤ鹶
	if(md->target_id){
		sd=map_id2sd(md->target_id);
		if(sd==NULL || sd->bl.m != md->bl.m || (dist=distance(md->bl.x,md->bl.y,sd->bl.x,sd->bl.y))>=13){
			// logout볦
			md->target_id=0;
		} else if(dist>=2){
			// ϰϳʤΤǰư

			if(md->timer>0 && (DIFF_TICK(md->next_walktime,tick)<0 || distance(md->to_x,md->to_y,sd->bl.x,sd->bl.y)<2))
				return 0; // ˰ư

			md->next_walktime=tick+500;
			i=0;
			do {
				dx=sd->bl.x - md->bl.x + rand()%3 - 1;
				dy=sd->bl.y - md->bl.y + rand()%3 - 1;
				ret=mob_walktoxy(md,md->bl.x+dx,md->bl.y+dy,0);
				i++;
			} while(ret && i<5);

			if(ret){ // ưԲǽʽ꤫ιʤ2Ⲽ
				if(dx<0) dx=2;
				else if(dx>0) dx=-2;
				if(dy<0) dy=2;
				else if(dy>0) dy=-2;
				mob_walktoxy(md,md->bl.x+dx,md->bl.y+dy,0);
			}
		} else { // in attack range
			// attack
			if(md->state==MS_ATTACK)
				return 0; // ˹
			mob_changestate(md,MS_ATTACK);
		}
		return 0;
	}

	// ʤˤ̵äʤưå
	if(DIFF_TICK(md->next_walktime,tick)<0){
		int i,x,y,c,d=15-md->move_fail_count;
		if(d<5) d=5;
		for(i=0;i<10;i++){
			int r=rand();
			x=md->bl.x+r%(d*2+1)-d;
			y=md->bl.y+r/(d*2+1)%(d*2+1)-d;
			if((c=map_getcell(md->bl.m,x,y))!=1 && c!=5 && mob_walktoxy(md,x,y,1)==0){
				md->move_fail_count=0;
				break;
			}
			if(i==10-1){
				md->move_fail_count++;
				if(md->move_fail_count>10){
					// printf("cant move. random spawn %d\n",md->bl.id);
					md->move_fail_count=0;
					mob_spawn(md->bl.id);
				}
			}
		}
		md->next_walktime = tick+rand()%5000+5000;
		return 0;
	}

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
static int mob_ai_sub_foreachclient(struct map_session_data *sd,va_list ap)
{
	unsigned int tick;

	tick=va_arg(ap,unsigned int);
	map_foreachinarea(mob_ai_sub_hard,sd->bl.m,
					  sd->bl.x-AREA_SIZE*2,sd->bl.y-AREA_SIZE*2,
					  sd->bl.x+AREA_SIZE*2,sd->bl.y+AREA_SIZE*2,
					  BL_MOB,tick);

	return 0;
}

/*==========================================
 * PC볦mobѤޤ (interval timerؿ)
 *------------------------------------------
 */
static int mob_ai_hard(int tid,unsigned int tick,int id,int data)
{
	clif_foreachclient(mob_ai_sub_foreachclient,tick);

	return 0;
}

/*==========================================
 *
 *------------------------------------------
 */
static int mob_ai_sub_lazy(void * key,void * data,va_list app)
{
	struct mob_data *md=data;
	unsigned int tick;
	va_list ap;

	if(md==NULL || md->bl.type!=BL_MOB)
		return 0;
	ap=va_arg(app,va_list);
	tick=va_arg(ap,unsigned int);

	if((unsigned)DIFF_TICK(tick,md->last_thinktime)<MIN_MOBTHINKTIME*10)
		return 0;
	md->last_thinktime=tick;

	// PCʤϤʤΤǼȴ⡼
	if(DIFF_TICK(md->next_walktime,tick)<0){
		md->move_fail_count++;
		if(md->move_fail_count>10){
			md->move_fail_count=0;
			mob_spawn(md->bl.id);
		}
		md->next_walktime = tick+rand()%20000+5000;
	}
	return 0;
}

/*==========================================
 * PC볦mobѼȴ (interval timerؿ)
 *------------------------------------------
 */
static int mob_ai_lazy(int tid,unsigned int tick,int id,int data)
{
	map_foreachiddb(mob_ai_sub_lazy,tick);

	return 0;
}


/*==========================================
 * delayդitem dropѹ¤
 * timerؿϤint 2ĤʤΤ
 * ι¤Τ˥ǡϤ
 *------------------------------------------
 */
struct delay_item_drop {
	int m,x,y;
	int nameid,amount;
};

/*==========================================
 * delayդitem drop (timerؿ)
 *------------------------------------------
 */
static int mob_delay_item_drop(int tid,unsigned int tick,int id,int data)
{
	struct delay_item_drop *ditem;
	struct item temp_item;

	ditem=(struct delay_item_drop *)id;

	memset(&temp_item,0,sizeof(temp_item));
	temp_item.nameid = ditem->nameid;
	temp_item.amount = ditem->amount;
	temp_item.identify = !itemdb_isequip(temp_item.nameid);
	map_addflooritem(&temp_item,1,ditem->m,ditem->x,ditem->y);

	free(ditem);
	return 0;
}

/*==========================================
 * id򹶷⤷ƤPCι
 * clif_foreachclientcallbackؿ
 *------------------------------------------
 */
int mob_stopattacked(struct map_session_data *sd,va_list ap)
{
	int id;

	id=va_arg(ap,int);
	if(sd->attacktarget==id)
		pc_stopattack(sd);
	return 0;
}

/*==========================================
 * mdsddamageΥ᡼
 *------------------------------------------
 */
int mob_damage(struct map_session_data *sd,struct mob_data *md,int damage)
{
	int i,sum,count,minpos,mindmg;
	struct map_session_data *tmpsd[DAMAGELOG_SIZE];

	if(md->state==MS_DEAD || md->hp<=0)
		return 0;

	if(md->state==MS_WALK){
		mob_changestate(md,MS_IDLE);
		clif_fixpos(&md->bl);
	}

	if(md->hp>mob_db[md->class].max_hp)
		md->hp=mob_db[md->class].max_hp;

	// over killʬϴݤ
	if(damage>md->hp)
		damage=md->hp;

	for(i=0,minpos=0,mindmg=30000;i<DAMAGELOG_SIZE;i++){
		if(md->dmglog[i].id==sd->bl.id)
			break;
		if(md->dmglog[i].id==0){
			minpos=i;
			mindmg=0;
		} else if(md->dmglog[i].dmg<mindmg){
			minpos=i;
			mindmg=md->dmglog[i].dmg;
		}
	}
	if(i<DAMAGELOG_SIZE)
		md->dmglog[i].dmg+=damage;
	else {
		md->dmglog[minpos].id=sd->bl.id;
		md->dmglog[minpos].dmg=damage;
	}

	md->hp-=damage;
	//printf("%d : %d/%d\n",md->bl.id,md->hp,mob_db[md->class].max_hp);

	md->attacked_id = sd->bl.id;

	if(md->hp>0)
		return 0;

	mob_changestate(md,MS_DEAD);

	// ΤǤmobؤιιߤ
	clif_foreachclient(mob_stopattacked,md->bl.id);


	memset(tmpsd,0,sizeof(tmpsd));

	// map˾äͤϷ׻Τ
	// overkillʬ̵summax_hpȤϰ㤦
	for(i=0,sum=0,count=0;i<DAMAGELOG_SIZE;i++){
		if(md->dmglog[i].id==0)
			continue;
		tmpsd[i] = map_id2sd(md->dmglog[i].id);
		if(tmpsd[i] == 0)
			continue;
		count++;
		if(tmpsd[i]->bl.m != md->bl.m)
			continue;
		sum+=md->dmglog[i].dmg;
	}
	// div0к
	if(sum==0)
		sum=mob_db[md->class].max_hp;

	for(i=0;i<DAMAGELOG_SIZE;i++){
		int per;
		if(tmpsd[i]==NULL || tmpsd[i]->bl.m != md->bl.m)
			continue;

		per=md->dmglog[i].dmg*256*(9+count)/10/sum;
		if(per>512) per=512;
		if(per<1) per=1;

		pc_gainexp(tmpsd[i],mob_db[md->class].base_exp*per/256,mob_db[md->class].job_exp*per/256);
	}

	// item drop
	for(i=0;i<8;i++){
		struct delay_item_drop *ditem;

		if(mob_db[md->class].dropitem[i].nameid==0 ||
		   mob_db[md->class].dropitem[i].p<rand()%10000)
			continue;

		ditem=malloc(sizeof(*ditem));
		if(ditem==NULL){
			printf("out of memory : mob_damage\n");
			exit(1);
		}

		ditem->nameid=mob_db[md->class].dropitem[i].nameid;
		ditem->amount=1;
		ditem->m=md->bl.m;
		ditem->x=md->bl.x;
		ditem->y=md->bl.y;
		add_timer(gettick()+500+i,mob_delay_item_drop,(int)ditem,0);
	}

	clif_clearchar_area(&md->bl,1);
	map_delblock(&md->bl);
	mob_setdelayspawn(md->bl.id);

	return 0;
}

//
// 
//
/*==========================================
 * ̤mobȤ줿Τǻ
 *------------------------------------------
 */
static int mob_makedummymobdb(int class)
{
	int i;

	sprintf(mob_db[class].name,"mob%d",class);
	sprintf(mob_db[class].jname,"mob%d",class);
	mob_db[class].lv=1;
	mob_db[class].max_hp=1000;
	mob_db[class].max_sp=1;
	mob_db[class].base_exp=2;
	mob_db[class].job_exp=1;
	mob_db[class].range=1;
	mob_db[class].atk1=7;
	mob_db[class].atk2=10;
	mob_db[class].def=0;
	mob_db[class].mdef=0;
	mob_db[class].str=1;
	mob_db[class].agi=1;
	mob_db[class].vit=1;
	mob_db[class].int_=1;
	mob_db[class].dex=6;
	mob_db[class].luk=2;
	mob_db[class].range2=10;
	mob_db[class].range3=10;
	mob_db[class].size=0;
	mob_db[class].race=0;
	mob_db[class].element=0;
	mob_db[class].mode=0;
	mob_db[class].speed=300;
	mob_db[class].adelay=1000;
	mob_db[class].amotion=500;
	mob_db[class].dmotion=500;
	mob_db[class].dropitem[0].nameid=909;	// Jellopy
	mob_db[class].dropitem[0].p=1000;
	for(i=1;i<8;i++){
		mob_db[class].dropitem[i].nameid=0;
		mob_db[class].dropitem[i].p=0;
	}
	// Item1,Item2
	mob_db[class].mexp=0;
	mob_db[class].mexpper=0;
	for(i=0;i<3;i++){
		mob_db[class].mvpitem[i].nameid=0;
		mob_db[class].mvpitem[i].p=0;
	}
	return 0;
}

/*==========================================
 * db/mob_db.txtɤ߹
 *------------------------------------------
 */
static int mob_readdb(void)
{
	FILE *fp;
	char line[1024];

	fp=fopen("db/mob_db.txt","r");
	if(fp==NULL){
		printf("can't read db/mob_db.txt\n");
		return -1;
	}
	while(fgets(line,1020,fp)){
		int class,i;
		char *str[55],*p,*np;

		for(i=0,p=line;i<55;i++){
			if((np=strchr(p,','))!=NULL){
				str[i]=p;
				*np=0;
				p=np+1;
			} else
				str[i]=p;
		}

		class=atoi(str[0]);
		if(class>=2000 || class==0)
			continue;

		memcpy(mob_db[class].name,str[1],24);
		memcpy(mob_db[class].jname,str[2],24);
		mob_db[class].lv=atoi(str[3]);
		mob_db[class].max_hp=atoi(str[4]);
		mob_db[class].max_sp=atoi(str[5]);
		mob_db[class].base_exp=atoi(str[6]);
		mob_db[class].job_exp=atoi(str[7]);
		mob_db[class].range=atoi(str[8]);
		mob_db[class].atk1=atoi(str[9]);
		mob_db[class].atk2=atoi(str[10]);
		mob_db[class].def=atoi(str[11]);
		mob_db[class].mdef=atoi(str[12]);
		mob_db[class].str=atoi(str[13]);
		mob_db[class].agi=atoi(str[14]);
		mob_db[class].vit=atoi(str[15]);
		mob_db[class].int_=atoi(str[16]);
		mob_db[class].dex=atoi(str[17]);
		mob_db[class].luk=atoi(str[18]);
		mob_db[class].range2=atoi(str[19]);
		mob_db[class].range3=atoi(str[20]);
		mob_db[class].size=atoi(str[21]);
		mob_db[class].race=atoi(str[22]);
		mob_db[class].element=atoi(str[23]);
		mob_db[class].mode=atoi(str[24]);
		mob_db[class].speed=atoi(str[25]);
		mob_db[class].adelay=atoi(str[26]);
		mob_db[class].amotion=atoi(str[27]);
		mob_db[class].dmotion=atoi(str[28]);
		for(i=0;i<8;i++){
			mob_db[class].dropitem[i].nameid=atoi(str[29+i*2]);
			mob_db[class].dropitem[i].p=atoi(str[30+i*2]);
		}
		// Item1,Item2
		mob_db[class].mexp=atoi(str[47]);
		mob_db[class].mexpper=atoi(str[48]);
		for(i=0;i<3;i++){
			mob_db[class].mvpitem[i].nameid=atoi(str[49+i*2]);
			mob_db[class].mvpitem[i].p=atoi(str[50+i*2]);
		}
	}
	fclose(fp);
	return 0;
}

/*==========================================
 * mob
 *------------------------------------------
 */
int do_init_mob(void)
{
	add_timer_func_list(mob_timer,"mob_timer");
	add_timer_func_list(mob_delayspawn,"mob_delayspawn");
	add_timer_func_list(mob_delay_item_drop,"mob_delay_item_drop");
	add_timer_func_list(mob_ai_hard,"mob_ai_hard");
	add_timer_func_list(mob_ai_lazy,"mob_ai_lazy");
	add_timer_interval(gettick()+100,mob_ai_hard,0,0,MIN_MOBTHINKTIME);
	add_timer_interval(gettick()+1000,mob_ai_lazy,0,0,MIN_MOBTHINKTIME*10);

	mob_readdb();

	return 0;
}
