#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef MEMWATCH
#include "memwatch.h"
#endif

#define _MALLOC_C_
#include "malloc.h"

// Ǝ}l[WgpꍇÃRgOĂB
// #define USE_MEMMGR

#ifndef USE_MEMMGR

void* aMalloc_( size_t size, const char *file, int line, const char *func )
{
	void *ret;
	
	// printf("%s:%d: in func %s: malloc %d\n",file,line,func,size);
#ifdef MEMWATCH
	ret=mwMalloc(size,file,line);
#else
	ret=malloc(size);
#endif
	if(ret==NULL){
		printf("%s:%d: in func %s: malloc error out of memory!\n",file,line,func);
		exit(1);

	}
	return ret;
}

void* aCalloc_( size_t num, size_t size, const char *file, int line, const char *func )
{
	void *ret;
	
	// printf("%s:%d: in func %s: calloc %d %d\n",file,line,func,num,size);
#ifdef MEMWATCH
	ret=mwCalloc(num,size,file,line);
#else
	ret=calloc(num,size);
#endif
	if(ret==NULL){
		printf("%s:%d: in func %s: calloc error out of memory!\n",file,line,func);
		exit(1);

	}
	return ret;
}

void* aRealloc_( void *p, size_t size, const char *file, int line, const char *func )
{
	void *ret;
	
	// printf("%s:%d: in func %s: realloc %p %d\n",file,line,func,p,size);
#ifdef MEMWATCH
	ret=mwRealloc(p,size,file,line);
#else
	ret=realloc(p,size);
#endif
	if(ret==NULL){
		printf("%s:%d: in func %s: realloc error out of memory!\n",file,line,func);
		exit(1);

	}
	return ret;
}

void* aStrdup_( const void *p, const char *file, int line, const char *func )
{
	void *ret;
	
	// printf("%s:%d: in func %s: strdup %p\n",file,line,func,p);
#ifdef MEMWATCH
	ret=mwStrdup(p,file,line);
#else
	ret=strdup(p);
#endif
	if(ret==NULL){
		printf("%s:%d: in func %s: strdup error out of memory!\n",file,line,func);
		exit(1);

	}
	return ret;
}

void aFree_( void *p, const char *file, int line, const char *func )
{
	// printf("%s:%d: in func %s: free %p\n",file,line,func,p);
#ifdef MEMWATCH
	mwFree(p,file,line);
#else
	free(p);
#endif
}

int do_init_memmgr(const char* file) {
	return 0;
}

#else /* USE_MEMMGR */

/*
 * }l[W
 *     malloc , free ̏Iɏo悤ɂ́B
 *     GȏsĂ̂ŁA኱dȂ邩܂B
 *
 * f[^\Ȃǁił܂^^; j
 *     E𕡐́uubNvɕāAɃubN𕡐́ujbgv
 *       ɕĂ܂Bjbg̃TCÝAPubN̗eʂ𕡐ɋϓz
 *       ̂łBƂ΁APjbg32KB̏ꍇAubNP32Bytẽ
 *       jbgA1024W܂ďoĂA64Bytẽjbg 512W܂
 *       oĂ肵܂Bipadding,unit_head j
 *
 *     Ejbgm̓NXg(block_prev,block_next) łȂATC
 *       YjbgmNXg(samesize_prev,samesize_nect) ł
 *       Ă܂BɂAsvƂȂ̍ėpIɍs܂B
 */

/* ubNɓf[^ */
#define BLOCK_DATA_SIZE	80*1024

/* xɊmۂubN̐B */
#define BLOCK_ALLOC		32

/* ubÑACg */
#define BLOCK_ALIGNMENT	64

/* ubN */
struct block {
	int    block_no;		/* ubNԍ */
	struct block* block_prev;		/* OɊmۂ̈ */
	struct block* block_next;		/* Ɋmۂ̈ */
	int    samesize_no;     /* TCY̔ԍ */
	struct block* samesize_prev;	/* TCY̑Ö̗ */
	struct block* samesize_next;	/* TCY̗̎̈ */
	int    unit_size;		/* jbg̃oCg 0=gp */
	int    unit_hash;		/* jbg̃nbV */
	int    unit_count;		/* jbg̐ */
	int    unit_used;		/* gpς݃jbg */
	char   data[BLOCK_DATA_SIZE];
};

struct unit_head {
	struct block* block;
	int    size;
	const  char* file;
	int    line;
};

static struct block* block_first  = NULL;
static struct block* block_last   = NULL;
static struct block* block_unused = NULL;

/* jbgւ̃nbVB80KB/64Byte = 1280 */
static struct block* unit_first[BLOCK_DATA_SIZE/BLOCK_ALIGNMENT];		/* ŏ */
static struct block* unit_unfill[BLOCK_DATA_SIZE/BLOCK_ALIGNMENT];	/* ܂ĂȂ */
static struct block* unit_last[BLOCK_DATA_SIZE/BLOCK_ALIGNMENT];		/* Ō */

/* g񂹂Ȃ̈p̃f[^ */
struct unit_head_large {
	struct unit_head_large* prev;
	struct unit_head_large* next;
	struct unit_head        unit_head;
};
static struct unit_head_large *unit_head_large_first = NULL;

static struct block* block_malloc(void);
static void   block_free(struct block* p);
static void memmgr_info(void);

void* aMalloc_(size_t size, const char *file, int line, const char *func ) {
	int i;
	struct block *block;
	int size_hash = (size+BLOCK_ALIGNMENT-1) / BLOCK_ALIGNMENT;
	size = size_hash * BLOCK_ALIGNMENT; /* ACg̔{ɐ؂グ */

	if(size == 0) {
		return NULL;
	}

	/* ubN𒴂̈̊mۂɂ́Amalloc() p */
	/* ̍ہAunit_head.block  NULL ċʂ */
	if(size > BLOCK_DATA_SIZE - sizeof(struct unit_head)) {
#ifdef MEMWATCH
		struct unit_head_large* p = (struct unit_head_large*)mwMalloc(sizeof(struct unit_head_large) + size,file,line);
#else
		struct unit_head_large* p = (struct unit_head_large*)malloc(sizeof(struct unit_head_large) + size);
#endif
		if(p != NULL) {
			p->unit_head.block = NULL;
			p->unit_head.size  = size;
			p->unit_head.file  = file;
			p->unit_head.line  = line;
			if(unit_head_large_first == NULL) {
				unit_head_large_first = p;
				p->next = NULL;
				p->prev = NULL;
			} else {
				unit_head_large_first->prev = p;
				p->prev = NULL;
				p->next = unit_head_large_first;
				unit_head_large_first = p;
			}
			return (char *)p + sizeof(struct unit_head_large);
		} else {
			printf("MEMMGR::memmgr_alloc failed.\n");
			exit(1);
		}
	}

	/* TCỸubNmۂĂȂAVɊmۂ */
	if(unit_unfill[size_hash] == NULL) {
		block = block_malloc();
		if(unit_first[size_hash] == NULL) {
			/* m */
			unit_first[size_hash] = block;
			unit_last[size_hash] = block;
			block->samesize_no = 0;
			block->samesize_prev = NULL;
			block->samesize_next = NULL;
		} else {
			/* A */
			unit_last[size_hash]->samesize_next = block;
			block->samesize_no   = unit_last[size_hash]->samesize_no + 1;
			block->samesize_prev = unit_last[size_hash];
			block->samesize_next = NULL;
			unit_last[size_hash] = block;
		}
		unit_unfill[size_hash] = block;
		block->unit_size  = size + sizeof(struct unit_head);
		block->unit_count = BLOCK_DATA_SIZE / block->unit_size;
		block->unit_used  = 0;
		block->unit_hash  = size_hash;
		/* gpFlag𗧂Ă */
		for(i=0;i<block->unit_count;i++) {
			((struct unit_head*)(&block->data[block->unit_size * i]))->block = NULL;
		}
	}
	/* jbggpZ */
	block = unit_unfill[size_hash];
	block->unit_used++;

	/* jbgSĎgʂ */
	if(block->unit_count == block->unit_used) {
		do {
			unit_unfill[size_hash] = unit_unfill[size_hash]->samesize_next;
		} while(
			unit_unfill[size_hash] != NULL &&
			unit_unfill[size_hash]->unit_count == unit_unfill[size_hash]->unit_used
		);
	}

	/* ubN̒̋󂫃jbg{ */
	for(i=0;i<block->unit_count;i++) {
		struct unit_head *head = (struct unit_head*)(&block->data[block->unit_size * i]);
		if(head->block == NULL) {
			head->block = block;
			head->size  = size;
			head->line  = line;
			head->file  = file;
			return (char *)head + sizeof(struct unit_head);
		}
	}
	// ɗĂ͂ȂB
	printf("MEMMGR::memmgr_malloc() serious error.\n");
	memmgr_info();
	exit(1);
	return NULL;
};

void* aCalloc_(size_t num, size_t size, const char *file, int line, const char *func ) {
	void *p = aMalloc_(num * size,file,line,func);
	memset(p,0,num * size);
	return p;
}

void* aRealloc_(void *memblock, size_t size, const char *file, int line, const char *func ) {
	size_t old_size;
	if(memblock == NULL) {
		return aMalloc_(size,file,line,func);
	}

	old_size = ((struct unit_head *)((char *)memblock - sizeof(struct unit_head)))->size;
	if(old_size > size) {
		// TCYk -> ̂܂ܕԂi蔲j
		return memblock;
	}  else {
		// TCYg
		void *p = aMalloc_(size,file,line,func);
		if(p != NULL) {
			memcpy(p,memblock,old_size);
		}
		aFree_(memblock,file,line,func);
		return p;
	}
}

void* aStrdup_(const void* string, const char *file, int line, const char *func ) {
	if(string == NULL) {
		return NULL;
	} else {
		int  len = strlen(string);
		char *p  = (char *)aMalloc_(len + 1,file,line,func);
		memcpy(p,string,len+1);
		return p;
	}
}

void aFree_(void *ptr, const char *file, int line, const char *func ) {
	struct unit_head *head = (struct unit_head *)((char *)ptr - sizeof(struct unit_head));
	if(ptr == NULL) {
		return;
	} else if(head->block == NULL && head->size > BLOCK_DATA_SIZE - sizeof(struct unit_head)) {
		/* malloc() ŒɊmۂꂽ̈ */
		struct unit_head_large *head_large = (struct unit_head_large *)((char *)ptr - sizeof(struct unit_head_large));
		if(head_large->prev) {
			head_large->prev->next = head_large->next;
		} else {
			unit_head_large_first  = head_large->next;
		}
		if(head_large->next) {
			head_large->next->prev = head_large->prev;
		}
		free(head_large);
		return;
	} else {
		/* jbg */
		struct block *block = head->block;
		if(head->block == NULL) {
			printf("memmgr: args of aFree is freed pointer %s line %d\n",file,line);
		} else {
			head->block = NULL;
			if(--block->unit_used == 0) {
				/* ubN̉ */
				if(unit_unfill[block->unit_hash] == block) {
					/* 󂫃jbgɎw肳Ă */
					do {
						unit_unfill[block->unit_hash] = unit_unfill[block->unit_hash]->samesize_next;
					} while(
						unit_unfill[block->unit_hash] != NULL &&
						unit_unfill[block->unit_hash]->unit_count == unit_unfill[block->unit_hash]->unit_used
					);
				}
				if(block->samesize_prev == NULL && block->samesize_next == NULL) {
					/* ƗubN̉ */
					unit_first[block->unit_hash]  = NULL;
					unit_last[block->unit_hash]   = NULL;
					unit_unfill[block->unit_hash] = NULL;
				} else if(block->samesize_prev == NULL) {
					/* 擪ubN̉ */
					unit_first[block->unit_hash] = block->samesize_next;
					(block->samesize_next)->samesize_prev = NULL;
				} else if(block->samesize_next == NULL) {
					/* [ubN̉ */
					unit_last[block->unit_hash] = block->samesize_prev; 
					(block->samesize_prev)->samesize_next = NULL;
				} else {
					/* ԃubN̉ */
					(block->samesize_next)->samesize_prev = block->samesize_prev;
					(block->samesize_prev)->samesize_next = block->samesize_next;
				}
				block_free(block);
			} else {
				/* 󂫃jbg̍Đݒ */
				if(
					unit_unfill[block->unit_hash] == NULL ||
					unit_unfill[block->unit_hash]->samesize_no > block->samesize_no
				) {
					unit_unfill[block->unit_hash] = block;
				}
			}
		}
	}
}

/* ݂̏󋵂\ */
static void memmgr_info(void) {
	int i;
	struct block *p;
	printf("** Memory Maneger Information **\n");
	if(block_first == NULL) {
		printf("Uninitialized.\n");
		return;
	}
	printf(
		"Blocks: %04u , BlockSize: %06u Byte , Used: %08uKB\n",
		block_last->block_no+1,sizeof(struct block),
		(block_last->block_no+1) * sizeof(struct block) / 1024
	);
	p = block_first;
	for(i=0;i<=block_last->block_no;i++) {
		printf("    Block #%04u : ",p->block_no);
		if(p->unit_size == 0) {
			printf("unused.\n");
		} else {
			printf(
				"size: %05u byte. used: %04u/%04u prev:",
				p->unit_size - sizeof(struct unit_head),p->unit_used,p->unit_count
			);
			if(p->samesize_prev == NULL) {
				printf("NULL");
			} else {
				printf("%04u",(p->samesize_prev)->block_no);
			}
			printf(" next:");
			if(p->samesize_next == NULL) {
				printf("NULL");
			} else {
				printf("%04u",(p->samesize_next)->block_no);
			}
			printf("\n");
		}
		p = p->block_next;
	}
}

/* ubNmۂ */
static struct block* block_malloc(void) {
	if(block_unused != NULL) {
		/* ubNp̗̈͊mۍς */
		struct block* ret = block_unused;
		do {
			block_unused = block_unused->block_next;
		} while(block_unused != NULL && block_unused->unit_size != 0);
		return ret;
	} else {
		/* ubNp̗̈VɊmۂ */
		int i;
		int  block_no;
		struct block* p = (struct block *)calloc(sizeof(struct block),BLOCK_ALLOC);
		if(p == NULL) {
			printf("MEMMGR::block_alloc failed.\n");
			exit(1);
		}
		if(block_first == NULL) {
			/* m */
			block_no     = 0;
			block_first  = p;
		} else {
			block_no      = block_last->block_no + 1;
			block_last->block_next = p;
			p->block_prev = block_last;
		}
		block_last = &p[BLOCK_ALLOC - 1];
		/* ubNA */
		for(i=0;i<BLOCK_ALLOC;i++) {
			if(i != 0) {
				p[i].block_prev = &p[i-1];
			}
			if(i != BLOCK_ALLOC -1) {
				p[i].block_next = &p[i+1];
			}
			p[i].block_no = block_no + i;
		}

		/* gpubNւ̃|C^XV */
		block_unused = &p[1];
		p->unit_size = 1;
		return p;
	}
}

static void block_free(struct block* p) {
	/* free() ɁAgptOt邾 */
	p->unit_size = 0;
	/* gp|C^[XV */
	if(block_unused == NULL) {
		block_unused = p;
	} else if(block_unused->block_no > p->block_no) {
		block_unused = p;
	}
}

static char memmer_logfile[128];

static FILE* memmgr_log(void) {
	FILE *fp = fopen(memmer_logfile,"a");
	if(!fp) { fp = stdout; }
	fprintf(fp,"memmgr: memory leaks found\n");
	return fp;
}

static void memmer_exit(void) {
	FILE *fp = NULL;
	int i;
	int count = 0;
	struct block *block = block_first;
	struct unit_head_large *large = unit_head_large_first;
	while(block) {
		if(block->unit_size) {
			if(!fp) { fp = memmgr_log(); }
			for(i=0;i<block->unit_count;i++) {
				struct unit_head *head = (struct unit_head*)(&block->data[block->unit_size * i]);
				if(head->block != NULL) {
					fprintf(
						fp,"%04d : %s line %d size %d\n",++count,
						head->file,head->line,head->size
					);
				}
			}
		}
		block = block->block_next;
	}
	while(large) {
		if(!fp) { fp = memmgr_log(); }
		fprintf(
			fp,"%04d : %s line %d size %d\n",++count,
			large->unit_head.file,
			large->unit_head.line,large->unit_head.size
		);
		large = large->next;
	}
	if(!fp) {
		printf("memmgr: no memory leaks found.\n");
	} else {
		printf("memmgr: memory leaks found.\n");
	}
}

int do_init_memmgr(const char* file) {
	sprintf(memmer_logfile,"%s.log",file);
	atexit(memmer_exit);
	printf("memmgr: initialised: %s\n",memmer_logfile);
	return 0;
}

#endif

