// $Id: login2.c,v 1.3 2003/07/06 07:56:09 lemit Exp $
// original : login2.c 2003/01/28 02:29:17 Rev.1.1.1.1
#define DUMP_UNKNOWN_PACKET	1

#ifndef _WIN32
	#include <sys/socket.h>
	#include <netinet/in.h>
	#include <sys/ioctl.h>
	#include <unistd.h>
	#include <signal.h>
	#include <fcntl.h>
	#include <arpa/inet.h>
	#include <sys/time.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "core.h"
#include "socket.h"
#include "login.h"
#include "mmo.h"
#include "version.h"
#include "db.h"
#include "lock.h"
#include "timer.h"
#include "malloc.h"
#include "timer.h"

#ifdef PASSWORDENC
#include "md5calc.h"
#endif

#ifdef MEMWATCH
#include "memwatch.h"
#endif

int server_num;
int new_account_flag = 0;
int login_port = 6900;
int login_autosave_time = 600;

struct mmo_char_server server[MAX_SERVERS];
int server_fd[MAX_SERVERS];
int login_fd;

#define AUTH_FIFO_SIZE 256
struct {
  int account_id,login_id1,login_id2;
  int ip,sex,delflag,tick;
} auth_fifo[AUTH_FIFO_SIZE];
int auth_fifo_pos=0;

char admin_pass[64]="";
char gm_pass[64]="";
const int gm_start=704554,gm_last=704583;
static char login_log_filename[1024] = "log/login.log";
int login_version = -1, login_type = -1;
int login_log(char *fmt,...);

#ifdef TXT_ONLY

static char account_filename[1024] = "save/account.txt";
static char GM_account_filename[1024] = "conf/GM_account.txt";
static int  auth_num=0,auth_max=0;
static int  account_id_count = START_ACCOUNT_NUM;
static struct mmo_account *auth_dat;
static struct dbt *gm_account_db;

static int read_gm_account(void);
static int isGM(int account_id);

int login_txt_init(void)
{
	// AJEgf[^x[X̓ǂݍ
	FILE *fp;
	int i,account_id,logincount,state,n,j,v;
	char line[1024],*p,userid[24],pass[24],lastlogin[24],sex;
	char str[64];
	if((fp=fopen(account_filename,"r"))==NULL)
		return 0;
	auth_max=256;
	auth_dat=aCalloc(auth_max,sizeof(auth_dat[0]));
	while(fgets(line,1023,fp)!=NULL){
		p=line;
		n=-1;
		i=sscanf(line,"%d\t%[^\t]\t%[^\t]\t%[^\t]\t%c\t%d\t%d\t%n",
			&account_id,userid,pass,lastlogin,&sex,&logincount,&state,&n);
		if(i>=5){
			if(auth_num>=auth_max){
				auth_max+=256;
				auth_dat=aRealloc(auth_dat,sizeof(auth_dat[0])*auth_max);
			}
			auth_dat[auth_num].account_id=account_id;
			strncpy(auth_dat[auth_num].userid,userid,24);
			strncpy(auth_dat[auth_num].pass,pass,24);
			strncpy(auth_dat[auth_num].lastlogin,lastlogin,24);
			auth_dat[auth_num].sex = sex == 'S' ? 2 : sex=='M';

			//f[^ȂƂ̕⊮
			if(i>=6)
				auth_dat[auth_num].logincount=logincount;
			else
				auth_dat[auth_num].logincount=1;
			if(i>=7)
				auth_dat[auth_num].state=state;
			else
				auth_dat[auth_num].state=0;

			if(n > 0) {
				for(j=0;j<ACCOUNT_REG2_NUM;j++){
					p+=n;
					if(sscanf(p,"%[^\t,],%d %n",str,&v,&n)!=2)
						break;
					strncpy(auth_dat[auth_num].account_reg2[j].str,str,32);
					auth_dat[auth_num].account_reg2[j].value=v;
				}
				auth_dat[auth_num].account_reg2_num=j;
			} else {
				auth_dat[auth_num].account_reg2_num=0;
			}

			auth_num++;
			if(account_id>=account_id_count)
				account_id_count=account_id+1;
		} else {
			i=0;
			if( sscanf(line,"%d\t%%newid%%\n%n",&account_id,&i)==1 &&
				i>0 && account_id>account_id_count)
				account_id_count=account_id;
		}
	}
	fclose(fp);

	read_gm_account();
	return 0;
}

// AJEgf[^x[X̏
void login_txt_sync(void)
{
	FILE *fp;
	int i,j,maxid=0,lock;
	fp=lock_fopen(account_filename,&lock);
	if(fp==NULL)
		return;
	for(i=0;i<auth_num;i++){
		if(auth_dat[i].account_id<0)
			continue;
		
		fprintf(fp,"%d\t%s\t%s\t%s\t%c\t%d\t%d\t",auth_dat[i].account_id,
			auth_dat[i].userid,auth_dat[i].pass,auth_dat[i].lastlogin,
			auth_dat[i].sex==2 ? 'S' : (auth_dat[i].sex ? 'M' : 'F'),
			auth_dat[i].logincount,auth_dat[i].state);
		
		for(j=0;j<auth_dat[i].account_reg2_num;j++){
			fprintf(fp,"%s,%d ",
				auth_dat[i].account_reg2[j].str,
				auth_dat[i].account_reg2[j].value);
		}
		fprintf(fp,RETCODE);
		
		if(maxid<auth_dat[i].account_id)
			maxid=auth_dat[i].account_id;
	}
	fprintf(fp,"%d\t%%newid%%\n",account_id_count);

	lock_fclose(fp,account_filename,&lock);
}

const struct mmo_account* login_txt_account_load_num(int account_id) {
	int x;
	for(x=0;x<auth_num;x++){
		if(auth_dat[x].account_id == account_id) {
			return &auth_dat[x];
		}
	}
	return NULL;
}

const struct mmo_account* login_txt_account_load_str(const char *account_id) {
	int x;
	for(x=0;x<auth_num;x++){
		if(!strncmp(auth_dat[x].userid,account_id,24)) {
			return &auth_dat[x];
		}
	}
	return NULL;
}

const struct mmo_account* login_txt_account_load_idx(int index) {
	if(index >= 0 && index < auth_num) {
		return &auth_dat[index];
	} else {
		return NULL;
	}
}

int login_txt_account_save(struct mmo_account *account) {
	int x;
	int account_id = account->account_id;
	for(x=0;x<auth_num;x++){
		if(auth_dat[x].account_id == account_id) {
			memcpy(&auth_dat[x],account,sizeof(struct mmo_account));
			return 1;
		}
	}
	return 0;
}

// AJEg폜
int login_txt_account_delete(int account_id) {
	int x;
	for(x=0;x<auth_num;x++){
		if(auth_dat[x].account_id == account_id) {
			memset(&auth_dat[x],0,sizeof(struct mmo_account));
			auth_dat[x].account_id = -1;
			return 1;
		}
	}
	return 0;
}

// AJEg쐬
int login_txt_account_new(struct mmo_account* account,const char *tmpstr) {
	int j,i=auth_num,c;
	login_log("auth new %s %s %s",tmpstr,account->userid,account->pass);
	
	for(j=0;j<24 && (c=account->userid[j]);j++){
		if(c<0x20 || c==0x7f)
			return 0;
	}
	if(login_txt_account_load_str(account->userid)) {
		// AJEgɑ
		return 0;
	}
	if(auth_num>=auth_max){
		auth_max+=256;
		auth_dat=aRealloc(auth_dat,sizeof(auth_dat[0])*auth_max);
	}
	while(isGM(account_id_count) > 0)
		account_id_count++;
	auth_dat[i].account_id = account_id_count++;
	auth_dat[i].sex        = account->sex;
	auth_dat[i].logincount = 0;
	auth_dat[i].state      = 0;
	strncpy(auth_dat[i].userid,account->userid,24);
	strncpy(auth_dat[i].pass  ,account->pass  ,24);
	strcpy(auth_dat[i].lastlogin,"-");
	auth_dat[i].account_reg2_num = 0;
	auth_num++;
	return 1;
}

static int gm_account_db_final(void *key,void *data,va_list ap)
{
	struct gm_account *p=data;

	free(p);

	return 0;
}

void login_txt_final(void) {
	if(auth_dat)
		free(auth_dat);
	if(gm_account_db)
		numdb_final(gm_account_db,gm_account_db_final);
}

int login_txt_config_read_sub(const char* w1,const char* w2) {
	if(strcmpi(w1,"account_filename")==0){
		strncpy(account_filename,w2,1024);
	} else if(strcmpi(w1,"gm_account_filename")==0){
		strncpy(GM_account_filename,w2,1024);
	}
	return 0;
}

static int isGM(int account_id)
{
	struct gm_account *p;
	p = numdb_search(gm_account_db,account_id);
	if( p == NULL)
		return 0;
	return p->level;
}

static int read_gm_account(void)
{
	char line[8192];
	struct gm_account *p;
	FILE *fp;
	int c=0;

	gm_account_db = numdb_init();

	if( (fp=fopen(GM_account_filename,"r"))==NULL )
		return 1;
	while(fgets(line,sizeof(line),fp)){
		if(line[0] == '/' && line[1] == '/')
			continue;
		p=(struct gm_account *)aCalloc(1,sizeof(struct gm_account));
		if(sscanf(line,"%d %d",&p->account_id,&p->level) != 2 || p->level <= 0) {
			printf("gm_account: broken data [%s] line %d\n",GM_account_filename,c);
		}
		else {
			if(p->level > 99)
				p->level = 99;
			numdb_insert(gm_account_db,p->account_id,p);
		}
		c++;
	}
	fclose(fp);
//	printf("gm_account: %s read done (%d gm account ID)\n",gm_account_txt,c);
	return 0;
}

#define login_init  login_txt_init
#define login_sync  login_txt_sync
#define login_final login_txt_final
#define login_config_read_sub  login_txt_config_read_sub
#define account_new      login_txt_account_new
#define account_save     login_txt_account_save
#define account_delete   login_txt_account_delete
#define account_load_num login_txt_account_load_num
#define account_load_str login_txt_account_load_str
#define account_load_idx login_txt_account_load_idx

#else /* TXT_ONLY */

//add include for DBMS(mysql)
#include <mysql.h>
MYSQL mysql_handle;

#ifdef _MSC_VER
#pragma comment(lib,"libmysql.lib")
#endif

int  login_server_port        = 3306;
char login_server_ip[32]      = "127.0.0.1";
char login_server_id[32]      = "ragnarok";
char login_server_pw[32]      = "ragnarok";
char login_server_db[32]      = "ragnarok";
char login_server_charset[32] = "";
char login_db[256]       = "login";
char loginlog_db[256]    = "loginlog";

// added to help out custom login tables, without having to recompile
// source so options are kept in the login_athena.conf or the inter_athena.conf
char login_db_account_id[256] = "account_id";
char login_db_userid[256]     = "userid";
char login_db_user_pass[256]  = "user_pass";
char login_db_level[256]      = "level";
char tmp_sql[65535];

static struct dbt *account_db;

char* strecpy (char* pt,const char* spt) {
	//copy from here
	mysql_real_escape_string(&mysql_handle,pt,spt,strlen(spt));
	return pt;
}

int  login_sql_init(void) {

	// DB connection start
	mysql_init(&mysql_handle);
	printf("Connecting Database Server");
	if(login_server_charset[0]) {
		printf(" (charset: %s)",login_server_charset);
	}
	printf("...\n");

	if (!mysql_real_connect(&mysql_handle, login_server_ip, login_server_id, login_server_pw,
	    login_server_db, login_server_port, (char *)NULL, 0)) {
		// pointer check
		printf("%s\n", mysql_error(&mysql_handle));
		exit(1);
	} else {
		printf("connect success!\n");
	}
	if(login_server_charset[0]) {
		sprintf(tmp_sql,"SET NAMES %s",login_server_charset);
		if (mysql_query(&mysql_handle, tmp_sql)) {
			printf("DB server Error (charset)- %s\n", mysql_error(&mysql_handle));
		}
	}

	sprintf(
		tmp_sql, "INSERT DELAYED INTO `%s`(`time`,`ip`,`user`,`rcode`,`log`) "
		"VALUES (NOW(), '', 'lserver', '100','login server started')", loginlog_db
	);

	//query
	if (mysql_query(&mysql_handle, tmp_sql)) {
		printf("DB server Error - %s\n", mysql_error(&mysql_handle));
	}

	account_db = numdb_init();

	return 0;
}

static int account_db_final(void *key,void *data,va_list ap)
{
	struct account *p=data;

	free(p);

	return 0;
}

void login_sql_final(void) {
	//set log.
	sprintf(
		tmp_sql,"INSERT DELAYED INTO `%s`(`time`,`ip`,`user`,`rcode`,`log`) VALUES "
		"(NOW(), '', 'lserver','100', 'login server shutdown')",loginlog_db
	);

	//query
	if (mysql_query(&mysql_handle, tmp_sql)) {
		printf("DB server Error - %s\n", mysql_error(&mysql_handle));
	}

	mysql_close(&mysql_handle);
	printf("close DB connect....\n");
	
	numdb_final(account_db,account_db_final);
}

void login_sql_sync(void) {
	// nothing to do
}

int  login_sql_config_read_sub(const char* w1,const char* w2) {
	if(strcmpi(w1,"login_server_ip")==0){
		strcpy(login_server_ip, w2);
	}
	else if(strcmpi(w1,"login_server_port")==0){
		login_server_port=atoi(w2);
	}
	else if(strcmpi(w1,"login_server_id")==0){
		strcpy(login_server_id, w2);
	}
	else if(strcmpi(w1,"login_server_pw")==0){
		strcpy(login_server_pw, w2);
	}
	else if(strcmpi(w1,"login_server_db")==0){
		strcpy(login_server_db, w2);
	}
	else if(strcmpi(w1,"login_server_charset")==0){
		strcpy(login_server_charset, w2);
	}

	return 0;
}

int login_sql_account_delete(int account_id) {
	sprintf(tmp_sql,"DELETE FROM `%s` WHERE `%s` = '%d'",login_db,login_db_account_id,account_id);
	if(mysql_query(&mysql_handle, tmp_sql)) {
		printf("DB server Error - %s\n", mysql_error(&mysql_handle));
	}
	sprintf(tmp_sql,"DELETE FROM `global_reg_value` WHERE `type`='1' AND `account_id`='%d'",account_id);
	if(mysql_query(&mysql_handle, tmp_sql)) {
		printf("DB server Error - %s\n", mysql_error(&mysql_handle));
	}
	return 0;
}

const struct mmo_account* login_sql_account_load_num(int account_id) {
	struct mmo_account *ac = numdb_search(account_db, account_id);
	MYSQL_RES* sql_res;
	MYSQL_ROW  sql_row = NULL;

	if(ac == NULL) {
		ac = aMalloc(sizeof(struct mmo_account));
		numdb_insert(account_db,account_id,ac);
	}

	// basic information
	sprintf(
		tmp_sql,
		"SELECT `%s`,`%s`,`lastlogin`,`logincount`,`sex`,`state` FROM `%s` WHERE `%s` = '%d'",
		login_db_userid,login_db_user_pass,login_db,login_db_account_id,account_id
	);
	if (mysql_query(&mysql_handle, tmp_sql)) {
		printf("DB server Error - %s\n", mysql_error(&mysql_handle));
	}
	sql_res = mysql_store_result(&mysql_handle);
	if (!sql_res) {
		printf("login_sql_account_load_num: DB result error ! \n");
		return NULL;
	}
	sql_row = mysql_fetch_row(sql_res);
	if (!sql_row) {
		// o^
		mysql_free_result(sql_res);
		return NULL;
	}
	memset(ac,0,sizeof(struct mmo_account));
	ac->account_id = account_id;
	strncpy(ac->userid    ,sql_row[0],24);
	strncpy(ac->pass      ,sql_row[1],24);
	strncpy(ac->lastlogin ,sql_row[2],24);
	ac->logincount = atoi(sql_row[3]);
	ac->sex        = sql_row[4][0];
	ac->state      = atoi(sql_row[5]);
	mysql_free_result(sql_res);
	if(ac->sex == 'M') {
		ac->sex = 1;
	} else if(ac->sex == 'S') {
		ac->sex = 2;
	} else {
		ac->sex = 0;
	}

	// global reg
	ac->account_reg2_num = 0;
	sprintf(tmp_sql, "SELECT `str`,`value` FROM `global_reg_value` WHERE `type`='1' AND `account_id`='%d'",account_id);
	if (mysql_query(&mysql_handle, tmp_sql)) {
		printf("DB server Error - %s\n", mysql_error(&mysql_handle));
	}
	sql_res = mysql_store_result(&mysql_handle);
	if (sql_res) {
		while( (sql_row = mysql_fetch_row(sql_res)) ) {
			memcpy(ac->account_reg2[ac->account_reg2_num].str,sql_row[0],32);
			ac->account_reg2[ac->account_reg2_num].value = atoi(sql_row[1]);
			ac->account_reg2_num++;
		}
	}
	mysql_free_result(sql_res);
	return ac;
}

const struct mmo_account* login_sql_account_load_str(const char *account_id) {
	int  id_num = -1;
	char buf[256];
	MYSQL_RES* sql_res;
	MYSQL_ROW  sql_row = NULL;

	sprintf(
		tmp_sql,"SELECT `%s` FROM `%s` WHERE `%s` = '%s'",
		login_db_account_id,login_db,login_db_userid,strecpy(buf,account_id)
	);
	if (mysql_query(&mysql_handle, tmp_sql)) {
		printf("DB server Error - %s\n", mysql_error(&mysql_handle));
	}
	sql_res = mysql_store_result(&mysql_handle) ;
	if (sql_res) {
		sql_row = mysql_fetch_row(sql_res);
		if(sql_row) {
			id_num  = atoi(sql_row[0]);
		}
	}
	mysql_free_result(sql_res);
	if(id_num >= 0) {
		return login_sql_account_load_num(id_num);
	} else {
		return NULL;
	}
}

const struct mmo_account* login_sql_account_load_idx(int index) {
	int  id_num = -1;
	MYSQL_RES* sql_res;
	MYSQL_ROW  sql_row = NULL;
	if(index < 0) return NULL;
	sprintf(
		tmp_sql,"SELECT `%s` FROM `%s` ORDER BY `%s` ASC LIMIT %d,1",
		login_db_account_id,login_db,login_db_account_id,index
	);
	if (mysql_query(&mysql_handle, tmp_sql)) {
		printf("DB server Error - %s\n", mysql_error(&mysql_handle));
	}
	sql_res = mysql_store_result(&mysql_handle) ;
	if (sql_res) {
		sql_row = mysql_fetch_row(sql_res);
		if(sql_row) {
			id_num  = atoi(sql_row[0]);
		}
	}
	mysql_free_result(sql_res);
	if(id_num >= 0) {
		return login_sql_account_load_num(id_num);
	} else {
		return NULL;
	}
	return NULL;
}

int  login_sql_account_save(struct mmo_account *ac2) {
	char *p;
	char buf[256];
	const struct mmo_account *ac1;
	char sep = ' ';

	// AJEg̑݊mF
	ac1 = login_sql_account_load_num(ac2->account_id);
	if(ac1 == NULL) return 0;

	// basic information
	p  = tmp_sql;
	p += sprintf(p,"UPDATE `%s` SET",login_db);

	// userid
	if(strncmp(ac1->userid,ac2->userid,24)) {
		p += sprintf(p,"%c`%s` = '%s'",sep,login_db_userid,strecpy(buf,ac2->userid));
		sep = ',';
	}

	// user_pass
	if(strncmp(ac1->pass,ac2->pass,24)) {
		p += sprintf(p,"%c`%s` = '%s'",sep,login_db_user_pass,strecpy(buf,ac2->pass));
		sep = ',';
	}

	// lastlogin
	if(strncmp(ac1->lastlogin,ac2->lastlogin,24)) {
		p += sprintf(p,"%c`lastlogin` = '%s'",sep,strecpy(buf,ac2->lastlogin));
		sep = ',';
	}

	// sex
	if(ac1->sex  != ac2->sex) {
		const char sex_str[] = "FMS";
		p += sprintf(p,"%c`sex` = '%c'",sep,sex_str[ac2->sex]);
		sep = ',';
	}

	// logincount
	if(ac1->logincount  != ac2->logincount) {
		p += sprintf(p,"%c`logincount` = '%d'",sep,ac2->logincount);
		sep = ',';
	}

	// state 
	if(ac1->state != ac2->state) {
		p += sprintf(p,"%c`state` = '%d'",sep,ac2->state);
		sep = ',';
	}

	if(sep == ',') {
		sprintf(p," WHERE `%s` = '%d'",login_db_account_id,ac2->account_id);
		if (mysql_query(&mysql_handle, tmp_sql)) {
			printf("DB server Error - %s\n", mysql_error(&mysql_handle));
		}
	}
	
	// account reg
	if(
		memcmp(ac1->account_reg2,ac2->account_reg2,sizeof(ac1->account_reg2)) ||
		ac1->account_reg2_num != ac2->account_reg2_num
	) {
		int i;
		sprintf(tmp_sql,"DELETE FROM `global_reg_value` WHERE `type`='1' AND `account_id`='%d'",ac2->account_id);
		if(mysql_query(&mysql_handle, tmp_sql)) {
			printf("DB server Error - %s\n", mysql_error(&mysql_handle));
		}
		for(i = 0;i < ac2->account_reg2_num ; i++) {
			sprintf(
				tmp_sql,
				"INSERT INTO `global_reg_value` (`type`, `account_id`, `str`, `value`) "
				"VALUES ( 1 , '%d' , '%s' , '%d')",
				ac2->account_id,
				strecpy(buf,ac2->account_reg2[i].str),ac2->account_reg2[i].value
			);
			if(mysql_query(&mysql_handle, tmp_sql)) {
				printf("DB server Error - %s\n", mysql_error(&mysql_handle));
			}
		}
	}

	return 0;
}

int  login_sql_account_new(struct mmo_account* account,const char *tmpstr) {
	int j,c;
	char buf1[256],buf2[256];
	char sex_str[] = "FMS";
	login_log("auth new %s %s %s",tmpstr,account->userid,account->pass);
	
	for(j=0;j<24 && (c=account->userid[j]);j++){
		if(c<0x20 || c==0x7f)
			return 0;
	}
	if(login_sql_account_load_str(account->userid)) {
		// AJEgɑ
		return 0;
	}
	sprintf(
		tmp_sql,
		"INSERT INTO `%s` (`%s`,`%s`,`lastlogin`,`sex`,`logincount`,`%s`,`state`) "
		"VALUES('%s','%s','-','%c','0','0','0')",
		login_db,login_db_userid,login_db_user_pass,login_db_level,
		strecpy(buf1,account->userid),strecpy(buf2,account->pass),
		sex_str[account->sex]
	);
	if(mysql_query(&mysql_handle, tmp_sql)) {
		printf("DB server Error - %s\n", mysql_error(&mysql_handle));
	}
	return 1;
}

#define login_init  login_sql_init
#define login_sync  login_sql_sync
#define login_final login_sql_final
#define login_config_read_sub  login_sql_config_read_sub
#define account_new      login_sql_account_new
#define account_save     login_sql_account_save
#define account_delete   login_sql_account_delete
#define account_load_num login_sql_account_load_num
#define account_load_str login_sql_account_load_str
#define account_load_idx login_sql_account_load_idx

#endif /* TXT_ONLY */

int login_log(char *fmt,...)
{
	FILE *logfp;
	va_list ap;
	va_start(ap,fmt);
	
	logfp=fopen(login_log_filename,"a");
	if(logfp){
		vfprintf(logfp,fmt,ap);
		fprintf(logfp,RETCODE);
		fclose(logfp);
	}
	
	va_end(ap);
	return 0;
}

// F
int mmo_auth(struct login_session_data* sd)
{
	char tmpstr[256];
	int len,newaccount=0;
	const struct mmo_account *ac;
	int encpasswdok=0;

#ifdef _WIN32
	{
		time_t time_;
		time(&time_);
		strftime(tmpstr,24,"%Y-%m-%d %H:%M:%S",localtime(&time_));
		sprintf(tmpstr+19,".%03d",0);
	}
#else
	{
		struct timeval tv;

		gettimeofday(&tv,NULL);
		strftime(tmpstr,24,"%Y-%m-%d %H:%M:%S",localtime(&(tv.tv_sec)));
		sprintf(tmpstr+19,".%03d",(int)tv.tv_usec/1000);
	}
#endif

	len=strlen(sd->userid)-2;
	if(sd->passwdenc==0 && sd->userid[len]=='_' &&
		(sd->userid[len+1]=='F' || sd->userid[len+1]=='M') &&
		new_account_flag == 1
	) {
		// VKAJEg쐬
		char *adm_pass=strchr(sd->pass,'@');
		if(adm_pass==NULL)
			adm_pass="";
		else
			adm_pass++;
		
		if(strcmp(adm_pass,admin_pass)==0) {
			if(adm_pass[0])
				*(adm_pass-1)=0;
			
			newaccount=1;
			sd->userid[len]=0;
		} else {
			sd->userid[0]=0;
		}
	}

	ac = account_load_str(sd->userid);
	if(!ac){
		// AJEgȂ
		if(newaccount == 0){
			// VK쐬ȊO
			login_log("auth failed no account %s %s %s %d",tmpstr,sd->userid,sd->pass,newaccount);
		} else {
			// VK쐬
			struct mmo_account ac2;
			memcpy(ac2.userid,sd->userid,24);
			memcpy(ac2.pass  ,sd->pass  ,24);
			ac2.sex = (sd->userid[len+1] == 'M');
			if( !account_new(&ac2,tmpstr) ){
				// 쐬s
				login_log("auth new failed %s %s %s %d",tmpstr,sd->userid,sd->pass,newaccount);
			}
		}
		return 0;
	}
	if(sd->passwdenc > 0){
		int j = sd->passwdenc;
		char md5str[64],md5bin[32];
		if(!sd->md5keylen){
			login_log("md5key not created %s %s",tmpstr,sd->userid);
			return 1;
		}
		if(j>2) j=1;
		do {
			if(j==1){
				strncpy(md5str,sd->md5key,20);
				strcat(md5str,ac->pass);
			}else if(j==2){
				strncpy(md5str,ac->pass,24);
				strcat(md5str,sd->md5key);
			} else
				md5str[0]=0;
			MD5_String2binary(md5str,md5bin);
			encpasswdok = ( memcmp( sd->pass, md5bin, 16) == 0);
		} while(j<2 && !encpasswdok && (j++) != sd->passwdenc);
//		printf("key[%s] md5 [%s] ",md5key,md5);
//		printf("client [%s] accountpass [%s]\n",account->passwd,auth_dat[i].pass);
		if(!encpasswdok) {
			// F؎s
			char logbuf[1024],*p=logbuf;
			int j;
			p+=sprintf(p,"auth failed pass error %s %s recv-md5[",tmpstr,sd->userid);
			for(j=0;j<16;j++)
				p+=sprintf(p,"%02x",((unsigned char *)sd->pass)[j]);
			p+=sprintf(p,"] calc-md5[");
			for(j=0;j<16;j++)
				p+=sprintf(p,"%02x",((unsigned char *)md5bin)[j]);
			p+=sprintf(p,"] md5key[");			
			for(j=0;j<sd->md5keylen;j++)
				p+=sprintf(p,"%02x",((unsigned char *)sd->md5key)[j]);
			p+=sprintf(p,"] %d",newaccount);
			login_log(logbuf);
			return 1;
		}
	} else if(strcmp(sd->pass,ac->pass) || newaccount) {
		// F؎s
		login_log("auth failed pass error %s %s %s %d",tmpstr,sd->userid,sd->pass,newaccount);
		return 1;
	}
	if(ac->state){
		login_log("auth banned account %s %s %s %d",tmpstr,sd->userid,ac->pass,ac->state);
		switch(ac->state) {
			case 1: return 2; break;
			case 2: return 3; break;
			case 3:	return 4; break;
		}
		return 2;
	}
	// Fؐ
	login_log("auth ok %s %s new=%d",tmpstr,ac->userid,newaccount);
	{
		struct mmo_account ac2;
		memcpy(&ac2,ac,sizeof(struct mmo_account));
		memcpy(ac2.lastlogin,tmpstr,24);
		ac2.logincount++;
		account_save(&ac2);

		// session data 
		sd->account_id = ac->account_id;
		sd->login_id1  = (rand() << 16) ^ rand();
		sd->login_id2  = (rand() << 16) ^ rand();
		sd->sex        = ac->sex;
		memcpy(sd->lastlogin,tmpstr,24);
	}
	return 100;
}

// ȊȎSĂcharT[o[Ƀf[^MiMmapI̐Ԃj
int charif_sendallwos(int sfd,unsigned char *buf,unsigned int len)
{
	int i,c;
	for(i=0,c=0;i<MAX_SERVERS;i++){
		int fd;
		if((fd=server_fd[i])>0 && fd!=sfd){
			memcpy(WFIFOP(fd,0),buf,len);
			WFIFOSET(fd,len);
			c++;
		}
	}
	return c;
}

int parse_char_disconnect(int fd) {
	int i;
 	for(i=0;i<MAX_SERVERS;i++)
		if(server_fd[i]==fd)
			server_fd[i]=-1;
	close(fd);
	delete_session(fd);
	return 0;
}

int parse_fromchar(int fd)
{
	int i,id;

	for(id=0;id<MAX_SERVERS;id++)
		if(server_fd[id]==fd)
			break;
	if(id==MAX_SERVERS)
		session[fd]->eof=1;
	while(RFIFOREST(fd)>=2){
		switch(RFIFOW(fd,0)){
		
		case 0x2712:	// LN^[Iւ̃OCF
			if(RFIFOREST(fd)<23)
				return 0;
			for(i=0;i<AUTH_FIFO_SIZE;i++){
				int ret=0;
				if( !(ret=(	auth_fifo[i].account_id==RFIFOL(fd,2) &&
						auth_fifo[i].login_id1==RFIFOL(fd,6) &&
					/*auth_fifo[i].login_id2==RFIFOL(fd,10) */ 1 ) ) ){
#ifdef CMP_AUTHFIFO_LOGIN2
					printf("login auth_fifo check lid2 %d %x %x\n",i,auth_fifo[i].login_id2,RFIFOL(fd,10));
				
					ret=(auth_fifo[i].login_id2==RFIFOL(fd,10));
#endif
#ifdef CMP_AUTHFIFO_IP
					printf("login auth_fifo check ip %d %x %x\n",i,auth_fifo[i].ip,RFIFOL(fd,15));
					ret|=(auth_fifo[i].ip==RFIFOL(fd,15) );
#endif
				}
				if(	ret &&
					auth_fifo[i].sex==RFIFOB(fd,14) &&
					!auth_fifo[i].delflag){
					auth_fifo[i].delflag=1;
//				 printf("%d\n",i);
					break;
				}
			}
	  
			if(i!=AUTH_FIFO_SIZE){	// account_regM
				int p,j;
				const struct mmo_account *ac = account_load_num(auth_fifo[i].account_id);
				if(ac){
					WFIFOW(fd,0) = 0x2729;
					WFIFOL(fd,4) = ac->account_id;
					for(p=8,j=0 ; j < ac->account_reg2_num ; p+=36,j++){
						memcpy(WFIFOP(fd,p),ac->account_reg2[j].str,32);
						WFIFOL(fd,p+32) = ac->account_reg2[j].value;
					}
					WFIFOW(fd,2)=p;
					WFIFOSET(fd,p);
//			printf("account_reg2 send : login->char (auth fifo)\n");
				}
			}
	  
			WFIFOW(fd,0)=0x2713;
			WFIFOL(fd,2)=RFIFOL(fd,2);
			if(i!=AUTH_FIFO_SIZE){
				WFIFOB(fd,6)=0;
			} else {
				WFIFOB(fd,6)=1;
			}
			WFIFOL(fd,7)=auth_fifo[i].account_id;
			WFIFOL(fd,11)=auth_fifo[i].login_id1;
			WFIFOSET(fd,15);
			RFIFOSKIP(fd,23);
			break;

		case 0x2714:	// [h̃[U[ʒm
			//printf("set users %s : %d\n",server[id].name,RFIFOL(fd,2));
			server[id].users=RFIFOL(fd,2);
			RFIFOSKIP(fd,6);
			break;

		case 0x2720:
			// GMɂȂ肽[
			// SQL ʓ|Ȃ̂łƂ肠ۗ
			WFIFOW(fd,0)=0x2721;
			WFIFOL(fd,2)=RFIFOL(fd,4);
			WFIFOL(fd,6)=RFIFOL(fd,4);
			WFIFOSET(fd,10);
			RFIFOSKIP(fd,RFIFOW(fd,2));
			return 0;

		case 0x2722:	// changesex
			if(RFIFOREST(fd)<4 || RFIFOREST(fd)<RFIFOW(fd,2))
				return 0;
			{
				const struct mmo_account *ac = account_load_num(RFIFOL(fd,4));
				if(ac) {
					struct mmo_account ac2;
					memcpy(&ac2,ac,sizeof(struct mmo_account));
					ac2.sex = RFIFOB(fd,8);
					account_save(&ac2);
				}
				WFIFOW(fd,0) = 0x2723;
				WFIFOL(fd,2) = RFIFOL(fd,4);
				WFIFOB(fd,6) = RFIFOB(fd,8);
				WFIFOSET(fd,7);
				RFIFOSKIP(fd,RFIFOW(fd,2));
			}
			return 0;

		case 0x2728:	// save account_reg
			if(RFIFOREST(fd)<4 || RFIFOREST(fd)<RFIFOW(fd,2))
				return 0;
			{
				int p,j;
				const struct mmo_account *ac = account_load_num(RFIFOL(fd,4));
				if(ac) {
					unsigned char buf[4096];
					struct mmo_account ac2;
					memcpy(&ac2,ac,sizeof(struct mmo_account));
					for(p=8,j=0;p<RFIFOW(fd,2) && j<ACCOUNT_REG2_NUM;p+=36,j++){
						memcpy(ac2.account_reg2[j].str,RFIFOP(fd,p),32);
						ac2.account_reg2[j].value = RFIFOL(fd,p+32);
					}
					ac2.account_reg2_num = j;
					account_save(&ac2);

					// ̃T[o[փ|XgiCOCȂΑȂĂj
					memcpy(WBUFP(buf,0),RFIFOP(fd,0),RFIFOW(fd,2));
					WBUFW(buf,0)=0x2729;
					charif_sendallwos(fd,buf,WBUFW(buf,2));
				}
				RFIFOSKIP(fd,RFIFOW(fd,2));
	//			printf("login: save account_reg (from char)\n");
			}
			break;

		case 0x272b:	//charT[oeiX
			if(RFIFOREST(fd)<3)
				return 0;
			server[id].maintenance=RFIFOB(fd,2);
			//charT[oɉ
			WFIFOW(fd,0)=0x272c;
			WFIFOB(fd,2)=server[id].maintenance;
			WFIFOSET(fd,3);
			
			RFIFOSKIP(fd,3);
			break;

		default:
			printf("login: unknown packet %x! (from char).\n",RFIFOW(fd,0));
			close(fd);
			session[fd]->eof=1;
			return 0;
		}
	}
	return 0;
}

int parse_admin_disconnect(int fd) {
	int i;
	for(i=0;i<MAX_SERVERS;i++)
		if(server_fd[i]==fd)
			server_fd[i]=-1;
	close(fd);
	delete_session(fd);
	return 0;
}

int parse_admin(int fd)
{
	int i;
	while(RFIFOREST(fd)>=2){
		switch(RFIFOW(fd,0)){
		case 0x7920:
			if(RFIFOREST(fd)<11)
				return 0;
			{
				// AJEgXg
				int st  = RFIFOL(fd,2);
				int ed  = RFIFOL(fd,6);
				int len = 4;
				const struct mmo_account* ac;
				RFIFOSKIP(fd,11);
				WFIFOW(fd,0)=0x7921;
				if(st<0)st=0;
				if(ed>END_ACCOUNT_NUM || ed<st || ed<=0) ed=END_ACCOUNT_NUM;
				i = 0;
				while( (ac = account_load_idx(i++) ) ) {
					if(ac->account_id >= st && ac->account_id <= ed){
						WFIFOL(fd,len   ) = ac->account_id;
						memcpy(WFIFOP(fd,len+4),ac->userid,24);
						WFIFOB(fd,len+28) = ac->sex;
						WFIFOL(fd,len+53) = ac->logincount;
						WFIFOL(fd,len+57) = ac->state;
						len+=61;
					}
				}
				WFIFOW(fd,2)=len;
				WFIFOSET(fd,len);
			}
			break;
		case 0x7930:
			if(RFIFOREST(fd)<4 || RFIFOREST(fd)<RFIFOW(fd,2))
				return 0;
			{
				// AJEg쐬
				struct mmo_account ma;
				memcpy(ma.userid,RFIFOP(fd, 4),24);
				memcpy(ma.pass  ,RFIFOP(fd,28),24);
				ma.sex = (RFIFOB(fd,52) == 'M');
				WFIFOW(fd,0) = 0x7931;
				WFIFOW(fd,2) = 0;
				memcpy(WFIFOP(fd,4),RFIFOP(fd,4),24);
				if( !account_new(&ma,"( ladmin )") ) {
					WFIFOW(fd,2)=1;
				}
				WFIFOSET(fd,28);
				RFIFOSKIP(fd,RFIFOW(fd,2));
			}
			break;
		case 0x7932:
			// AJEg폜
			if(RFIFOREST(fd)<4 || RFIFOREST(fd)<RFIFOW(fd,2))
				return 0;
			{
				const struct mmo_account *ac = account_load_str(RFIFOP(fd,4));
				WFIFOW(fd,0) = 0x7933;
				WFIFOW(fd,2) = 1;
				memcpy(WFIFOP(fd,4),RFIFOP(fd,4),24);
				if(ac) {
					// LT[o[֍폜ʒm
					unsigned char buf[16];
					WBUFW(buf,0) = 0x272a;
					WBUFL(buf,2) = ac->account_id;
					charif_sendallwos(-1,buf,6);
					WFIFOW(fd,2) = 0;

					account_delete(ac->account_id);
				}
				WFIFOSET(fd,28);
				RFIFOSKIP(fd,RFIFOW(fd,2));
			}
			break;
		case 0x7934:
			// pX[hύX
			if(RFIFOREST(fd)<4 || RFIFOREST(fd)<RFIFOW(fd,2))
				return 0;
			{
				const struct mmo_account *ac = account_load_str(RFIFOP(fd,4));
				WFIFOW(fd,0)=0x7935;
				WFIFOW(fd,2)=1;
				memcpy(WFIFOP(fd,4),RFIFOP(fd,4),24);
				if(ac) {
					struct mmo_account ac2;
					memcpy(&ac2,ac,sizeof(struct mmo_account));
					memcpy(ac2.pass,RFIFOP(fd,28),24);
					account_save(&ac2);

					WFIFOW(fd,2)=0;
				}
				WFIFOSET(fd,28);
				RFIFOSKIP(fd,RFIFOW(fd,2));
			}
			break;
		case 0x7936:
			// oԕύX
			if(RFIFOREST(fd)<4 || RFIFOREST(fd)<RFIFOW(fd,2))
				return 0;
			{
				const struct mmo_account *ac = account_load_str(RFIFOP(fd,4));
				WFIFOW(fd, 0) = 0x7937;
				WFIFOW(fd, 2) = 1;
				WFIFOL(fd,28) = 0;
				memcpy(WFIFOP(fd,4),RFIFOP(fd,4),24);
				if(ac) {
					struct mmo_account ac2;
					memcpy(&ac2,ac,sizeof(struct mmo_account));
					ac2.state=RFIFOL(fd,28);
					account_save(&ac2);
					WFIFOW(fd, 2) = 0;
					WFIFOL(fd,28) = ac2.state;
				}
				WFIFOSET(fd,32);
				RFIFOSKIP(fd,RFIFOW(fd,2));
			}
			break;
		default:
			close(fd);
			session[fd]->eof=1;
			return 0;
		}
	}
	return 0;
}

int parse_login_disconnect(int fd) {
	int i;
	for(i=0;i<MAX_SERVERS;i++)
		if(server_fd[i]==fd)
	server_fd[i]=-1;
	close(fd);
	delete_session(fd);
	return 0;
}

int parse_login(int fd)
{
	struct login_session_data *sd = session[fd]->session_data;
	int result=0,i;
	if(sd == NULL) {
		sd = session[fd]->session_data = aCalloc(sizeof(struct login_session_data),1);
	}
	while(RFIFOREST(fd)>=2){
		if(RFIFOW(fd,0)<30000) {
			if(RFIFOW(fd,0) == 0x64 || RFIFOW(fd,0) == 0x01dd)
				printf("parse_login : %d %d %d %s\n",fd,RFIFOREST(fd),RFIFOW(fd,0),RFIFOP(fd,6));
			else
				printf("parse_login : %d %d %d\n",fd,RFIFOREST(fd),RFIFOW(fd,0));
		}
		switch(RFIFOW(fd,0)){
		case 0x204:		//20040622ÍragexeΉ
			if(RFIFOREST(fd)<18)
				return 0;
			RFIFOSKIP(fd,18);
			break;
		case 0x200:		//NCAgaccountIvVgp̓pPbgւ̑Ή
			if(RFIFOREST(fd)<26)
				return 0;
			RFIFOSKIP(fd,26);
			break;
		case 0x64:		// NCAgOCv
		case 0x01dd:	// ÍOCv
			if(RFIFOREST(fd)< ((RFIFOW(fd,0)==0x64)?55:47))
				return 0;
			{
				unsigned char *p=(unsigned char *)&session[fd]->client_addr.sin_addr;
				login_log("client connection request %s from %d.%d.%d.%d",
					RFIFOP(fd,6),p[0],p[1],p[2],p[3]);
			}
	
			if(login_version > 0 && RFIFOL(fd,2) != login_version)	//KÕo[W̐ڑ
				result = 0x03;
			if(login_type > 0 && RFIFOB(fd,(RFIFOW(fd,0)==0x64)?54:46) != login_type)	//KÕ^Cv̐ڑ
				result = 0x03;

			memcpy(sd->userid,RFIFOP(fd, 6),24);
			memcpy(sd->pass  ,RFIFOP(fd,30),(RFIFOW(fd,0)==0x64 ? 24 : 16));
#ifdef PASSWORDENC
			sd->passwdenc = (RFIFOW(fd,0)==0x64) ? 0 : PASSWORDENC;
#else
			sd->passwdenc = 0;
#endif
			if(result == 0) {
				result = mmo_auth(sd);
			}
			if(result == 100) {
				server_num=0;
				for(i=0;i<MAX_SERVERS;i++){
					if(server_fd[i]>=0){
						WFIFOL(fd,47+server_num*32) = server[i].ip;
						WFIFOW(fd,47+server_num*32+4) = server[i].port;
						memcpy(WFIFOP(fd,47+server_num*32+6), server[i].name, 20);
						WFIFOW(fd,47+server_num*32+26) = server[i].users;
						WFIFOW(fd,47+server_num*32+28) = server[i].maintenance;
						WFIFOW(fd,47+server_num*32+30) = server[i].new;
						server_num++;
					}
				}
				WFIFOW(fd, 0) = 0x69;
				WFIFOW(fd, 2) = 47+32*server_num;
				WFIFOL(fd, 4) = sd->login_id1;
				WFIFOL(fd, 8) = sd->account_id;
				WFIFOL(fd,12) = sd->login_id2;
				WFIFOL(fd,16) = 0;
				memcpy(WFIFOP(fd,20),sd->lastlogin,24);
				WFIFOB(fd,46) = sd->sex;
				WFIFOSET(fd,47+32*server_num);
				if(auth_fifo_pos>=AUTH_FIFO_SIZE){
					auth_fifo_pos=0;
				}
				auth_fifo[auth_fifo_pos].account_id = sd->account_id;
				auth_fifo[auth_fifo_pos].login_id1  = sd->login_id1;
				auth_fifo[auth_fifo_pos].login_id2  = sd->login_id2;
				auth_fifo[auth_fifo_pos].sex        = sd->sex;
				auth_fifo[auth_fifo_pos].delflag    = 0;
				auth_fifo[auth_fifo_pos].tick       = gettick();
				auth_fifo[auth_fifo_pos].ip         = session[fd]->client_addr.sin_addr.s_addr;
				auth_fifo_pos++;
			} else {
				memset(WFIFOP(fd,0),0,23);
				WFIFOW(fd,0) = 0x6a;
				WFIFOB(fd,2) = result;
				WFIFOSET(fd,23);
			}
			RFIFOSKIP(fd,(RFIFOW(fd,0)==0x64)?55:47);
			break;
		case 0x01db:	// ÍKeyMv
		case 0x791a:	// ǗpPbgňÍkeyv
			if(sd->md5keylen){
				printf("login: illeagal md5key request.");
				close(fd);
				session[fd]->eof=1;
				return 0;
			}
			// ÍL[
			sd->md5keylen = rand()%4+12;
			for(i=0;i<sd->md5keylen;i++)
				sd->md5key[i]=rand()%255+1;
	
			RFIFOSKIP(fd,2);
			WFIFOW(fd,0)=0x01dc;
			WFIFOW(fd,2)=4+sd->md5keylen;
			memcpy(WFIFOP(fd,4),sd->md5key,sd->md5keylen);
			WFIFOSET(fd,WFIFOW(fd,2));
			break;

		case 0x2710:	// CharT[o[ڑv
			if(RFIFOREST(fd)<84)
				return 0;
			{
				unsigned char *p=(unsigned char *)&session[fd]->client_addr.sin_addr;
				login_log(
					"server connection request %s @ %d.%d.%d.%d:%d (%d.%d.%d.%d)",
					RFIFOP(fd,60),RFIFOB(fd,54),RFIFOB(fd,55),RFIFOB(fd,56),RFIFOB(fd,57),
					RFIFOW(fd,58),p[0],p[1],p[2],p[3]
				);
			}
			memcpy(sd->userid ,RFIFOP(fd, 2),24);
			memcpy(sd->pass   ,RFIFOP(fd,26),24);
			sd->passwdenc = 0;
			result = mmo_auth(sd);
			if(result == 100 && sd->sex == 2 && sd->account_id<MAX_SERVERS && server_fd[sd->account_id]<0){
				server[sd->account_id].ip=RFIFOL(fd,54);
				server[sd->account_id].port=RFIFOW(fd,58);
				memcpy(server[sd->account_id].name,RFIFOP(fd,60),20);
				server[sd->account_id].users=0;
				server[sd->account_id].maintenance=RFIFOW(fd,80);
				server[sd->account_id].new=RFIFOW(fd,82);
				server_fd[sd->account_id]=fd;
				WFIFOW(fd,0)=0x2711;
				WFIFOB(fd,2)=0;
				WFIFOSET(fd,3);
				session[fd]->func_parse    = parse_fromchar;
				session[fd]->func_destruct = parse_char_disconnect;
				realloc_fifo(fd,FIFOSIZE_SERVERLINK,FIFOSIZE_SERVERLINK);	
			} else {
				WFIFOW(fd,0)=0x2711;
				WFIFOB(fd,2)=3;
				WFIFOSET(fd,3);
			}
			RFIFOSKIP(fd,84);
			return 0;
	
		case 0x7530:	// Athena񏊓
			WFIFOW(fd,0)=0x7531;
			WFIFOB(fd,2)=ATHENA_MAJOR_VERSION;
			WFIFOB(fd,3)=ATHENA_MINOR_VERSION;
			WFIFOB(fd,4)=ATHENA_REVISION;
			WFIFOB(fd,5)=ATHENA_RELEASE_FLAG;
			WFIFOB(fd,6)=ATHENA_OFFICIAL_FLAG;
			WFIFOB(fd,7)=ATHENA_SERVER_LOGIN;
			WFIFOW(fd,8)=ATHENA_MOD_VERSION;
			WFIFOSET(fd,10);
			RFIFOSKIP(fd,2);
			break;
		case 0x7532:	// ڑ̐ؒf(defaultƏ͈ꏏIɂ邽)
			close(fd);
			session[fd]->eof=1;
			return 0;
		
		case 0x7918:	// Ǘ[hOC
			{
				struct login_session_data *ld=session[fd]->session_data;
				if(RFIFOREST(fd)<4 || RFIFOREST(fd)<RFIFOW(fd,2))
					return 0;
	
				WFIFOW(fd,0)=0x7919;
				WFIFOB(fd,2)=1;
				
				if(RFIFOW(fd,4)==0){	// v[
					if(strcmp(RFIFOP(fd,6),admin_pass)==0){
						WFIFOB(fd,2)=0;
						session[fd]->func_parse=parse_admin;
						session[fd]->func_destruct = parse_admin_disconnect;
					}
				}else{					// Í
					if(!ld){
						printf("login: md5key not created for admin login\n");
					}else{
						char md5str[64]="",md5bin[32];
						if(RFIFOW(fd,4)==1){
							strncpy(md5str,ld->md5key,20);
							strcat(md5str,admin_pass);
						}else if(RFIFOW(fd,4)==2){
							strncpy(md5str,admin_pass,64);
							strcat(md5str,ld->md5key);
						};
						MD5_String2binary(md5str,md5bin);
						if(memcmp(md5bin,RFIFOP(fd,6),16)==0){
							WFIFOB(fd,2)=0;
							session[fd]->func_parse=parse_admin;
							session[fd]->func_destruct = parse_admin_disconnect;
						}
					}
				}
				WFIFOSET(fd,3);
				RFIFOSKIP(fd,RFIFOW(fd,2));
			}
			break;
	
		default:
#ifdef DUMP_UNKNOWN_PACKET
			{
				int i;
				printf("---- 00-01-02-03-04-05-06-07-08-09-0A-0B-0C-0D-0E-0F");
				for(i=0;i<RFIFOREST(fd);i++){
					if((i&15)==0)
						printf("\n%04X ",i);
					printf("%02X ",RFIFOB(fd,i));
				}
				printf("\n");
			}
#endif
			close(fd);
			session[fd]->eof=1;
			return 0;
		}
	}
	return 0;
}

int login_config_read(const char *cfgName)
{
	int i;
	char line[1024],w1[1024],w2[1024];
	FILE *fp;

	fp=fopen(cfgName,"r");
	if(fp==NULL){
		printf("file not found: %s\n",cfgName);
		return 1;
	}
	while(fgets(line,1020,fp)){
		if(line[0] == '/' && line[1] == '/')
			continue;

		i=sscanf(line,"%[^:]: %[^\r\n]",w1,w2);
		if(i!=2)
			continue;

		if(strcmpi(w1,"admin_pass")==0){
			strncpy(admin_pass,w2,64);
		}
		else if(strcmpi(w1,"gm_pass")==0){
			strncpy(gm_pass,w2,64);
		}
		else if(strcmpi(w1,"new_account")==0){
			new_account_flag = atoi(w2);
		}
		else if(strcmpi(w1,"login_port")==0){
			login_port=atoi(w2);
		}
		else if(strcmpi(w1,"order")==0 || strcmpi(w1,"deny")==0 || strcmpi(w1,"allow")==0) {
			// login_athena.conf ̃ANZX́Asocket.conf ɓ܂B
			printf("login_config_read: Access control in login_athena.conf is no more\n");
			printf("                   supported. Please use socket.conf instead of this.\n");
		}
		else if(strcmpi(w1,"import")==0){
			login_config_read(w2);
		}
		else if(strcmpi(w1,"login_version")==0){
			login_version=atoi(w2);
		}
		else if(strcmpi(w1,"login_type")==0){
			login_type=atoi(w2);
		}
		else if(!strcmpi(w1,"autosave_time")) {
			int temp = atoi(w2);
			if(temp > 10) {
				login_autosave_time = temp;
			}
		}
		else if(strcmpi(w1,"login_log_filename")==0){
			strncpy(login_log_filename,w2,1024);
		}
		else login_config_read_sub(w1,w2);
	}
	fclose(fp);

	return 0;
}

int login_sync_timer(int tid, unsigned int tick, int id,int data) {
	login_sync();
	return 0;
}

void do_final(void)
{
	int i;

	login_final();
	exit_dbn();

	for(i=0;i<MAX_SERVERS;i++){
		int fd;
		if((fd=server_fd[i])>0){
			delete_session(fd);
		}
	}
	delete_session(login_fd);
}

int do_init(int argc,char **argv)
{
	int i;

	printf("Athena Login Server [%s] v%d.%d.%d mod%d\n",
#ifdef TXT_ONLY
		"TXT",
#else
		"SQL",
#endif
		ATHENA_MAJOR_VERSION,ATHENA_MINOR_VERSION,ATHENA_REVISION,
		ATHENA_MOD_VERSION
	);
	login_config_read( (argc>1)?argv[1]:LOGIN_CONF_NAME );
	srand(time(NULL));

	for(i=0;i<AUTH_FIFO_SIZE;i++){
		auth_fifo[i].delflag=1;
	}
	for(i=0;i<MAX_SERVERS;i++){
		server_fd[i]=-1;
	}
	login_fd = make_listen_port(login_port);
	login_init();
	set_termfunc(login_sync);
	set_defaultparse(parse_login);
	set_sock_destruct(parse_login_disconnect);

	add_timer_func_list(login_sync_timer,"login_sync_timer");
	add_timer_interval(gettick()+10*1000,login_sync_timer,0,0,login_autosave_time*1000);
	atexit(do_final);
	return 0;
}
